<?php
session_start();
// Simulamos acceso para desarrollo; en producción, valida tu sesión real.
if (!isset($_SESSION['Acceso']) && !isset($_GET['debug'])) { 
    // $_SESSION['Acceso'] = 'AccesoSiqueSi'; // Descomentar para probar rápido
    // exit("Acceso Denegado"); 
}

$config = [
    'titulo'          => 'Gestión de Usuarios',
    'subtitulo'       => 'Directorio maestro de clientes',
    'db_name'         => 'MS_Usuario',
    'tabla_sql'       => 'Usuarios',
    
    // CORRECCIÓN 1: La llave primaria debe coincidir con la columna definida abajo
    'primary_key'     => 'IDU', 
    
    'consulta_select' => "SELECT * FROM MS_Usuario.Usuarios ORDER BY IDU DESC;",

    'columnas' => [
        // La key 'IDU' ahora coincide con 'primary_key'
        ['key' => 'IDU',        'label' => 'ID',        'visible' => true,  'editable' => false],
        ['key' => 'Nombre',     'label' => 'Nombre',    'visible' => true,  'editable' => true],
        ['key' => 'Telefono_1', 'label' => 'Móvil',     'visible' => true,  'editable' => true],
        ['key' => 'EMail',      'label' => 'Correo',    'visible' => true,  'editable' => true],
        ['key' => 'Direccion',  'label' => 'Ubicación', 'visible' => true,  'editable' => true]
    ],

    'campos_formulario' => [
        [ 'name' => 'Nombre',     'label' => 'Nombre Completo', 'type' => 'text',   'required' => true ],
        [ 'name' => 'Telefono_1', 'label' => 'Teléfono',        'type' => 'number', 'required' => true ],
        [ 'name' => 'EMail',      'label' => 'Correo Elec.',    'type' => 'email',  'required' => true ],
        [ 'name' => 'Direccion',  'label' => 'Dirección',       'type' => 'text',   'required' => false ]
    ],

    'acciones' => [
        'globales' => [ 'crear', 'excel', 'recargar' ], 
        
        'fila' => [ 
            'inline-edit', 
            'eliminar',    
            
            // Acción Custom Corregida
            [
                'tipo'    => 'custom',
                'titulo'  => 'Ver Ficha Técnica',
                'icono'   => 'fas fa-id-card', // Icono más acorde
                'color'   => 'info',
                // CORRECCIÓN 2: Placeholder usa la PK correcta {IDU}
                'onclick' => "verFicha('{IDU}')" 
            ]
        ]
    ]
];

include '../librerias/Tablas/TablaSimple.php';
?>
<script>
    function verFicha(id) { 
        Swal.fire({
            title: 'Ficha Técnica', 
            text: 'Analizando datos del IDU: ' + id, 
            icon: 'info',
            confirmButtonText: 'Entendido'
        }); 
    }
</script>