<?php
// 1. SEGURIDAD Y CONTEXTO
session_start();
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso Denegado");
}

// Variables de Configuración
$nombre_bd = "MS_Datos";
// Aseguramos que $IDU esté disponible para las consultas de la base de datos de usuarios
$IDU = $_SESSION['IDU']; 
$prefijo = isset($IDU) ? $IDU : '101'; 
$tb_suc = $prefijo . "-Sucursales"; 

// --- CONFIGURACIÓN DE USUARIOS ---
$db_usuarios = "MS_Usuario";
$tb_usuarios = "Usuarios";
// ---------------------------------

// Lógica de carga de usuarios (Dejada en JS/Fetch para mantener el patrón AJAX)
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    /* Estilos Generales */
    body { background-color: #f4f7f6; }
    
    /* Métricas */
    .card-metric {
        border: none; border-radius: 12px; transition: transform 0.2s;
        background: white; box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    .card-metric:hover { transform: translateY(-3px); }
    
    /* Tabla */
    .table-suc thead th {
        font-size: 0.75rem; text-transform: uppercase; letter-spacing: 1px;
        color: #6c757d; border-bottom: 2px solid #e9ecef; background: #f8f9fa;
    }
    
    /* Avatar de Sucursal (Icono) */
    .avatar-suc {
        width: 45px; height: 45px; 
        background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);
        color: white; border-radius: 10px; 
        display: flex; align-items: center; justify-content: center;
        font-size: 1.2rem;
    }

    /* Modal */
    .modal-fullscreen .modal-dialog { width: 95%; max-width: 95%; margin: 10px auto; }
    .input-hero { font-size: 1.3rem; font-weight: 700; height: 50px; }
    
    /* Sección Configuración */
    .config-header {
        background: #f0f9ff; border-left: 4px solid #0ea5e9;
        padding: 10px 15px; margin-bottom: 15px; border-radius: 0 5px 5px 0;
        font-weight: bold; color: #0369a1; text-transform: uppercase; font-size: 0.85rem;
    }
</style>

<div class="container-fluid p-3">
    
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="text-muted text-uppercase font-weight-bold">Total Sucursales</small>
                        <h3 class="mb-0 text-dark font-weight-bold" id="kpi_total">0</h3>
                    </div>
                    <div class="icon-shape bg-light text-primary rounded-circle p-3"><i class="fas fa-store-alt fa-2x"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="text-muted text-uppercase font-weight-bold">Operativas (Activas)</small>
                        <h3 class="mb-0 text-success font-weight-bold" id="kpi_activas">0</h3>
                    </div>
                    <div class="icon-shape bg-light text-success rounded-circle p-3"><i class="fas fa-check-circle fa-2x"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="text-muted text-uppercase font-weight-bold">Sin Encargado</small>
                        <h3 class="mb-0 text-danger font-weight-bold" id="kpi_sin_encargado">0</h3>
                    </div>
                    <div class="icon-shape bg-light text-danger rounded-circle p-3"><i class="fas fa-user-slash fa-2x"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-header bg-white py-3">
            <div class="row align-items-center">
                <div class="col-md-5">
                    <h5 class="mb-0 font-weight-bold text-dark"><i class="fas fa-network-wired mr-2"></i>Red de Sucursales</h5>
                </div>
                <div class="col-md-7 text-right">
                    <div class="d-flex justify-content-end gap-2">
                        <button class="btn btn-success text-white shadow-sm mr-2" onclick="exportarExcel()">
                            <i class="fas fa-file-excel mr-1"></i> Excel
                        </button>
                        <div class="input-group" style="width: 300px;">
                            <span class="input-group-text bg-white border-right-0"><i class="fas fa-search text-muted"></i></span>
                            <input type="text" id="buscador" class="form-control border-left-0 pl-0" placeholder="Buscar Sucursal, Código o Encargado...">
                            <button class="btn btn-dark ml-2 rounded" onclick="abrirModal()">
                                <i class="fas fa-plus mr-1"></i> Nueva
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-hover align-middle table-suc mb-0">
                <thead>
                    <tr>
                        <th width="60" class="pl-4">#</th>
                        <th>Nombre / Código</th>
                        <th>Ubicación & Contacto</th>
                        <th>Encargado</th>
                        <th class="text-center">Estado</th>
                        <th class="text-right pr-4">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tabla_body"></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade modal-fullscreen" id="modalEdicion" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-dark text-white py-3">
                <h5 class="modal-title font-weight-bold"><i class="fas fa-store mr-2"></i>Gestión de Sucursal</h5>
                <button type="button" class="btn btn-outline-light btn-sm ml-auto mr-2" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success btn-sm px-4 font-weight-bold shadow" onclick="guardarSucursal()">
                    <i class="fas fa-save mr-1"></i> GUARDAR
                </button>
            </div>
            
            <div class="modal-body bg-light p-4">
                <form id="formSuc">
                    <input type="hidden" id="IDS">
                    
                    <div class="row">
                        <div class="col-lg-6 mb-4">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-white font-weight-bold text-uppercase text-primary">Identificación y Ubicación</div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-md-8">
                                            <label class="form-label font-weight-bold text-dark">Nombre de la Sucursal *</label>
                                            <input type="text" class="form-control input-hero border-primary" id="nombre" placeholder="Ej: Sucursal Centro">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label text-muted">Código Interno</label>
                                            <input type="text" class="form-control input-hero bg-light" id="codigo" placeholder="SUC-01">
                                        </div>
                                    </div>
                                    
                                    <div class="form-group mb-3">
                                        <label class="form-label text-muted">Dirección Completa</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-map-marker-alt"></i></span>
                                            <textarea class="form-control" id="direccion" rows="2" placeholder="Calle, Número, Colonia, Ciudad..."></textarea>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label class="form-label text-muted">Teléfono de Sucursal</label>
                                            <div class="input-group"><span class="input-group-text bg-light"><i class="fas fa-phone-alt"></i></span><input type="text" class="form-control" id="telefono"></div>
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label class="form-label text-muted">Estado Operativo</label>
                                            <select class="form-control" id="activo">
                                                <option value="1">🟢 Abierta / Activa</option>
                                                <option value="0">🔴 Cerrada / Inactiva</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6 mb-4">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-white font-weight-bold text-uppercase text-info">
                                    <i class="fas fa-cogs mr-2"></i>Operación
                                </div>
                                <div class="card-body">
                                    <div class="form-group mb-4">
                                        <label class="form-label font-weight-bold">Encargado / Gerente</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-tie"></i></span>
                                            <select class="form-control font-weight-bold" id="IDU_Encargado">
                                                <option value="0">-- Sin Encargado --</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <hr>

                                    <div class="config-header"><i class="fas fa-sliders-h mr-2"></i>Configuración Operativa</div>
                                    
                                    <div class="form-group mb-3">
                                        <label class="small text-muted">Horario de Atención</label>
                                        <input type="text" class="form-control conf-field" id="conf_horario" placeholder="Ej: Lunes a Viernes 9am - 6pm">
                                    </div>

                                    <div class="form-group">
                                        <label class="small text-muted">Mensaje en Ticket (Pie de página)</label>
                                        <input type="text" class="form-control conf-field" id="conf_mensaje_ticket" placeholder="¡Gracias por su compra!">
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Configuración
    const DB = "<?php echo $nombre_bd; ?>";
    const TB_SUC = "<?php echo $tb_suc; ?>";
    const DB_USERS = "<?php echo $db_usuarios; ?>";
    const TB_USERS = "<?php echo $tb_usuarios; ?>";
    const IDU_GLOBAL = "<?php echo $IDU; ?>";

    // Variables globales para almacenar la lista de usuarios cargada
    let usersMap = {}; // Para buscar el nombre por ID rápidamente

    document.addEventListener('DOMContentLoaded', () => {
        cargarUsuarios(); // Carga la lista de usuarios al inicio
        listarSucursales();
        
        document.getElementById('buscador').addEventListener('keyup', function(e) {
            const term = e.target.value.toLowerCase();
            document.querySelectorAll('#tabla_body tr').forEach(row => {
                const text = row.innerText.toLowerCase();
                row.style.display = text.includes(term) ? '' : 'none';
            });
        });
    });
    
    // --- FUNCIÓN NUEVA: CARGA DE USUARIOS PARA EL SELECT ---
    function cargarUsuarios() {
        const select = document.getElementById('IDU_Encargado');
        // Consulta adaptada a tu estructura para cargar solo usuarios activos asociados a tu negocio (IDUg)
         const sql = `SELECT Usuarios.IDU AS IDU, Nombre FROM MS_Usuario.Usuarios, MS_Usuario.Usuarios_Datos WHERE Usuarios.IDU=Usuarios_Datos.IDU  AND IDUg=<?php echo $IDUg;?>  AND Estado="Activo" ORDER BY Nombre;`;
        
        
        select.innerHTML = '<option value="0">-- Cargando Usuarios --</option>';
        usersMap = {0: '-- Sin Asignar --'};

        fetch('../librerias/AJAX/Select.php', {
            method: 'POST', 
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `sql=${encodeURIComponent(sql)}&db=${DB_USERS}`
        })
        .then(r => r.json())
        .then(res => {
            let opts = '<option value="0">-- Sin Asignar --</option>';
            if(res.data && res.data.length > 0) {
                res.data.forEach(user => {
                    opts += `<option value="${user.IDU}">${user.Nombre}</option>`;
                    usersMap[user.IDU] = user.Nombre;
                });
            }
            select.innerHTML = opts;
        })
        .catch(err => {
            select.innerHTML = '<option value="0">-- ERROR al cargar Usuarios --</option>';
            console.error("Error al cargar usuarios:", err);
        });
    }

    // --- 1. LISTAR ---
    function listarSucursales() {
        const tbody = document.getElementById('tabla_body');
        tbody.innerHTML = '<tr><td colspan="6" class="text-center p-4"><i class="fas fa-circle-notch fa-spin text-muted"></i></td></tr>';

        const sql = `SELECT * FROM \`${TB_SUC}\` ORDER BY IDS ASC`;

        fetch('../librerias/AJAX/Select.php', {
            method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `sql=${encodeURIComponent(sql)}&db=${DB}`
        })
        .then(r => r.json())
        .then(res => {
            tbody.innerHTML = '';
            let total = 0, activas = 0, sinEncargado = 0;

            if(res.data && res.data.length > 0) {
                res.data.forEach(row => {
                    // La tabla Sucursales debe tener la columna IDU_Encargado
                    const iduEncargado = parseInt(row.encargado || 0); 
                    const nombreEncargado = usersMap[iduEncargado] || '<span class="text-danger small">Sin Asignar</span>';
                    
                    total++;
                    if(row.activo == 1) activas++;
                    if(iduEncargado === 0) sinEncargado++;

                    const iniciales = row.nombre.substring(0,2).toUpperCase();
                    const estadoIcon = row.activo == 1 
                        ? `<span class="badge bg-success bg-opacity-10 text-success border border-success px-2">Abierta</span>` 
                        : `<span class="badge bg-danger bg-opacity-10 text-danger border border-danger px-2">Cerrada</span>`;

                    let horario = "";
                    try {
                        const conf = JSON.parse(row.Datos);
                        if(conf && conf.horario) horario = `<div class="small text-info"><i class="fas fa-clock mr-1"></i>${conf.horario}</div>`;
                    } catch(e) {}

                    tbody.innerHTML += `
                        <tr>
                            <td class="pl-4"><div class="avatar-suc shadow-sm">${iniciales}</div></td>
                            <td>
                                <div class="font-weight-bold text-dark">${row.nombre}</div>
                                <small class="text-muted font-monospace"><i class="fas fa-tag mr-1"></i>${row.codigo || 'S/N'}</small>
                            </td>
                            <td>
                                <div class="text-dark small text-truncate" style="max-width:250px" title="${row.direccion}"><i class="fas fa-map-pin text-muted mr-1"></i>${row.direccion || 'Sin dirección'}</div>
                                ${row.telefono ? `<div class="small text-muted"><i class="fas fa-phone mr-1"></i>${row.telefono}</div>` : ''}
                                ${horario}
                            </td>
                            <td>
                                <div class="text-dark font-weight-bold"><i class="fas fa-user-circle text-muted mr-1"></i>${nombreEncargado}</div>
                            </td>
                            <td class="text-center">${estadoIcon}</td>
                            <td class="text-right pr-4">
                                <button class="btn btn-sm btn-light border mr-1" onclick='editarSucursal(${JSON.stringify(row)})'><i class="fas fa-edit text-primary"></i></button>
                                ${row.IDS != 1 ? `<button class="btn btn-sm btn-light border" onclick="eliminarSucursal(${row.IDS}, '${row.nombre}')"><i class="fas fa-trash text-danger"></i></button>` : ''}
                            </td>
                        </tr>
                    `;
                });
                
                document.getElementById('kpi_total').innerText = total;
                document.getElementById('kpi_activas').innerText = activas;
                document.getElementById('kpi_sin_encargado').innerText = sinEncargado;
            } else {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center text-muted py-5">No hay sucursales registradas.</td></tr>';
            }
        });
    }

    // --- 2. GUARDAR (CORREGIDO PARA GUARDAR IDU_Encargado) ---
    function guardarSucursal() {
        const id = document.getElementById('IDS').value;
        const nombre = document.getElementById('nombre').value.trim();
        
        if(!nombre) { Swal.fire('Error', 'El nombre es obligatorio', 'warning'); return; }

        // Empaquetar Configuración en JSON
        const confObj = {
            horario: document.getElementById('conf_horario').value,
            mensaje_ticket: document.getElementById('conf_mensaje_ticket').value
        };
        const datosJSON = JSON.stringify(confObj);

        const p = {
            nom: nombre,
            cod: document.getElementById('codigo').value,
            dir: document.getElementById('direccion').value,
            tel: document.getElementById('telefono').value,
            // IDU: Valor numérico del <select>
            idu: document.getElementById('IDU_Encargado').value, 
            act: document.getElementById('activo').value,
            datos: datosJSON
        };

        const safe = (str) => str ? String(str).replace(/'/g, "\\'") : '';
        
        let sql = "";
        if(id) {
            // CORRECCIÓN: Usamos p.idu (valor numérico del select) y la columna IDU_Encargado
            sql = `UPDATE \`${TB_SUC}\` SET 
                   nombre='${safe(p.nom)}', codigo='${safe(p.cod)}', direccion='${safe(p.dir)}', 
                   telefono='${safe(p.tel)}', encargado=${p.idu}, activo='${p.act}', 
                   Datos='${safe(p.datos)}'
                   WHERE IDS = ${id}`;
        } else {
            // CORRECCIÓN: Aseguramos la columna IDU_Encargado en INSERT y su valor
            sql = `INSERT INTO \`${TB_SUC}\` 
                   (nombre, codigo, direccion, telefono, encargado, activo, Datos) 
                   VALUES ('${safe(p.nom)}', '${safe(p.cod)}', '${safe(p.dir)}', '${safe(p.tel)}', ${p.idu}, '${p.act}', '${safe(p.datos)}')`;
        }
        
        // La columna IDU_Encargado debe ser de tipo INT o compatible.
        // Si fuera VARCHAR, quitarías los {p.idu} y los encerrarías entre comillas: '${p.idu}'.

        fetch('../librerias/AJAX/Execute.php', {
            method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `sql=${encodeURIComponent(sql)}&db=${DB}`
        })
        .then(r => r.json())
        .then(res => {
            if(res.error) {
                 Swal.fire('Error de Guardado', 'Hubo un error al ejecutar la base de datos. Revise la consola.', 'error');
                 console.error('SQL Error:', res.error);
            }
            else {
                Swal.fire({icon: 'success', title: 'Guardado', toast: true, position: 'top-end', showConfirmButton: false, timer: 1500});
                $('#modalEdicion').modal('hide');
                listarSucursales();
            }
        });
    }

    // --- 3. EDITAR ---
    function editarSucursal(row) {
        document.getElementById('IDS').value = row.IDS;
        document.getElementById('nombre').value = row.nombre;
        document.getElementById('codigo').value = row.codigo || '';
        document.getElementById('direccion').value = row.direccion || '';
        document.getElementById('telefono').value = row.telefono || '';
        document.getElementById('activo').value = row.activo;
        
        // CORRECCIÓN: Aseguramos que el valor se asigna correctamente al select
        // Debe ser un string que coincida con el valor de la opción
        document.getElementById('IDU_Encargado').value = String(row.IDU_Encargado || 0); 
        
        // Limpiar campos config
        document.querySelectorAll('.conf-field').forEach(el => el.value = '');
        
        try {
            if(row.Datos) {
                const conf = JSON.parse(row.Datos);
                document.getElementById('conf_horario').value = conf.horario || '';
                document.getElementById('conf_mensaje_ticket').value = conf.mensaje_ticket || '';
            }
        } catch(e) { console.error("JSON Error al cargar Datos extra:", e); }
        
        $('#modalEdicion').modal('show');
    }

    // --- 4. ELIMINAR ---
    function eliminarSucursal(id, nombre) {
        if(id == 1) { Swal.fire('Acción Denegada', 'La Sucursal General no puede eliminarse.', 'error'); return; }

        Swal.fire({
            title: '¿Cerrar Sucursal?', 
            text: `Vas a eliminar "${nombre}". Asegúrate de no tener inventario vinculado.`, 
            icon: 'warning', showCancelButton: true, confirmButtonColor: '#d33', confirmButtonText: 'Sí, eliminar'
        }).then((result) => {
            if (result.isConfirmed) {
                const sql = `DELETE FROM \`${TB_SUC}\` WHERE IDS = ${id}`;
                fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} }).then(() => listarSucursales());
            }
        });
    }

    function abrirModal() {
        document.getElementById('formSuc').reset();
        document.getElementById('IDS').value = '';
        document.getElementById('activo').value = 1;
        document.getElementById('IDU_Encargado').value = 0; // Asegurar valor por defecto
        $('#modalEdicion').modal('show');
    }

    function exportarExcel() {
        const tableElement = document.createElement('table');
        tableElement.setAttribute('border', '1');
        
        // Encabezados
        tableElement.innerHTML = `
            <thead>
                <tr style="background-color: #3b82f6; color: white;">
                    <th>ID</th>
                    <th>NOMBRE SUCURSAL</th>
                    <th>CODIGO</th>
                    <th>DIRECCION</th>
                    <th>TELEFONO</th>
                    <th>ENCARGADO (NOMBRE)</th>
                    <th>ESTADO</th>
                </tr>
            </thead>
            <tbody id="excel_tbody"></tbody>
        `;

        const sql = `SELECT * FROM \`${TB_SUC}\` ORDER BY IDS ASC`;

        fetch('../librerias/AJAX/Select.php', {
            method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `sql=${encodeURIComponent(sql)}&db=${DB}`
        })
        .then(r => r.json())
        .then(res => {
            if (res.data && res.data.length > 0) {
                const tbody = tableElement.querySelector('#excel_tbody');
                res.data.forEach(row => {
                    const nombreEncargado = usersMap[parseInt(row.IDU_Encargado)] || 'Sin Asignar';
                    tbody.innerHTML += `
                        <tr>
                            <td>${row.IDS}</td>
                            <td>${row.nombre}</td>
                            <td>${row.codigo || ''}</td>
                            <td>${row.direccion || ''}</td>
                            <td>${row.telefono || ''}</td>
                            <td>${nombreEncargado}</td>
                            <td>${row.activo == 1 ? 'ACTIVA' : 'INACTIVA'}</td>
                        </tr>
                    `;
                });
            }
            
            // Descarga
            const html = tableElement.outerHTML;
            const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = `Reporte_Sucursales_${new Date().toISOString().slice(0,10)}.xls`;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    }
</script>