<?php
/**
 * PVNotas.php - V3.2 FINAL
 * Corrección: Detalle de venta (Costo_Original) y Sincronización con Modal de Impresión
 */
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') { die("Acceso denegado."); }

$idUsuario  = $_SESSION['IDUg'] ?? '1'; 
$idSucursal = $_SESSION['IDS'] ?? '1';
$dbName     = $_SESSION['BD'] ?? "MS_Datos"; 
$prefijo    = $idUsuario . "-"; 
$vendedor   = $_SESSION['NombreUsuario'] ?? "Vendedor";

try {
    $pdo = new PDO("mysql:host=localhost;dbname=$dbName;charset=utf8", "root", "33comRxXMysql"); 
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmtImp = $pdo->query("SELECT * FROM `{$prefijo}Configuracion_Impresoras` WHERE Activo = 1");
    $impresorasData = $stmtImp->fetchAll(PDO::FETCH_ASSOC);

    $hoy = date('ymd'); 
    $prefijoFolio = "NV-" . $hoy . "-";
    $sqlFolio = "SELECT Folio FROM `{$prefijo}Ventas_Cabecera` WHERE Folio LIKE '$prefijoFolio%' ORDER BY ID_Venta DESC LIMIT 1";
    $resFolio = $pdo->query($sqlFolio)->fetch(PDO::FETCH_ASSOC);
    $nuevoContador = $resFolio ? intval(substr($resFolio['Folio'], -3)) + 1 : 1;
    $folioNota = $prefijoFolio . str_pad($nuevoContador, 3, "0", STR_PAD_LEFT);
} catch (Exception $e) { die("Error: " . $e->getMessage()); }

// Motor de impresión que gestiona Documentos_generados
include_once('../librerias/Modulos/ImpresoraNV.php'); 
?>

<style>
    :root { --primary: #4e73df; --success: #1cc88a; --bg: #f4f7fa; --dark: #2d3436; --danger: #e74a3b; }
    .pos-wrapper-centered { background: var(--bg); min-height: calc(100vh - 65px); width: 100%; margin: -25px; display: flex; justify-content: center; padding: 20px; }
    .nota-container { background: #fff; width: 100%; max-width: 850px; padding: 40px; border: 2px solid #333; border-radius: 20px; font-family: 'Arial', sans-serif; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
    
    .header-nota { display: flex; justify-content: flex-end; margin-bottom: 25px; }
    .box-folio { border: 2px solid #333; border-radius: 12px; width: 220px; text-align: center; overflow: hidden; }
    .title-folio { background: #444; color: #fff; padding: 6px; font-weight: bold; font-size: 13px; }
    .content-folio { padding: 12px; font-weight: bold; color: var(--danger); font-size: 18px; }

    .cliente-box { border: 2px solid #333; border-radius: 15px; padding: 20px; margin-bottom: 25px; background: #fdfdfd; position: relative; }
    .row-cli { display: flex; gap: 15px; margin-bottom: 12px; border-bottom: 1px solid #ddd; padding-bottom: 8px; position: relative; }
    .row-cli label { font-weight: bold; font-size: 13px; min-width: 90px; color: #555; }
    .row-cli input { border: none; flex: 1; outline: none; font-size: 15px; background: transparent; }

    .tabla-productos { border: 2px solid #333; border-radius: 15px; width: 100%; border-collapse: separate; border-spacing: 0; overflow: hidden; }
    .tabla-productos th { background: #555; color: #fff; border: 1px solid #333; padding: 12px; font-size: 14px; text-align: center; }
    .tabla-productos td { border: 1px solid #333; padding: 0; position: relative; }
    .tabla-productos input { border: none; width: 100%; padding: 12px; outline: none; font-size: 14px; text-align: center; }
    .tabla-productos input.desc { text-align: left; padding-left: 15px; }

    .suggestions { position: absolute; background: #fff; width: 100%; z-index: 1000; border: 1px solid #333; display: none; border-radius: 0 0 10px 10px; max-height: 180px; overflow-y: auto; box-shadow: 0 4px 10px rgba(0,0,0,0.2); }
    .sug-item { padding: 10px 15px; cursor: pointer; border-bottom: 1px solid #eee; font-size: 13px; text-align: left; }
    .sug-item:hover { background: #f0f4ff; color: var(--primary); font-weight: bold; }

    .footer-nota { display: flex; margin-top: 25px; border: 2px solid #333; border-radius: 15px; overflow: hidden; }
    .obs-box { flex: 1; padding: 15px; border-right: 2px solid #333; background: #fff; }
    
    .totals-box { width: 320px; background: #fff; }
    .row-total { display: flex; border-bottom: 1px solid #333; height: 50px; align-items: center; }
    .row-total label { background: #f4f4f4; width: 130px; padding: 0 15px; font-weight: bold; font-size: 12px; height: 100%; display: flex; align-items: center; border-right: 1px solid #333; margin: 0; }
    .row-total span, .row-total input { flex: 1; padding: 0 15px; text-align: right; font-weight: bold; font-size: 16px; border: none; outline: none; background: transparent; }
    #txt-total { color: var(--danger) !important; font-size: 24px !important; }
</style>

<div class="pos-wrapper-centered">
    <div class="nota-container">
        <div class="header-nota">
            <div class="box-folio">
                <div class="title-folio">NOTA DE VENTA</div>
                <div class="content-folio" id="lbl-folio"><?= $folioNota ?></div>
                <div class="title-folio">FECHA</div>
                <div style="padding: 8px; font-weight: bold;"><?= date('d / m / Y') ?></div>
            </div>
        </div>

        <div class="cliente-box">
            <div class="row-cli">
                <label>CLIENTE <span class="text-danger">*</span>:</label>
                <input type="text" id="cli-nombre" placeholder="Nombre completo..." autocomplete="off">
                <input type="hidden" id="cli-id" value="0">
                <div id="res-cli-search" class="suggestions" style="top: 35px; left: 105px; width: calc(100% - 105px);"></div>
            </div>
            <div style="display:flex; gap: 20px;">
                <div class="row-cli" style="flex:1"><label>TELÉFONO <span class="text-danger">*</span>:</label><input type="text" id="cli-tel"></div>
                <div class="row-cli" style="flex:1"><label>E-MAIL:</label><input type="email" id="cli-email"></div>
            </div>
        </div>

        <div class="tabla-wrapper">
            <table class="tabla-productos">
                <thead><tr><th width="80">CANT.</th><th>DESCRIPCIÓN</th><th width="120">P. UNIT.</th><th width="120">IMPORTE</th></tr></thead>
                <tbody id="nota-body">
                    <?php for($i=0; $i<5; $i++): ?>
                    <tr class="item-row">
                        <td><input type="number" class="val-cant" step="any" onchange="calcRow(this)"></td>
                        <td>
                            <input type="text" class="desc" onkeyup="searchProd(this)" autocomplete="off">
                            <div class="suggestions"></div>
                            <input type="hidden" class="sku-hidden">
                        </td>
                        <td><input type="number" class="val-price" step="any" onchange="calcRow(this)"></td>
                        <td><input type="text" class="val-importe" readonly value="0.00"></td>
                    </tr>
                    <?php endfor; ?>
                </tbody>
            </table>
            <button class="btn btn-sm btn-link text-dark mt-2" onclick="addMoreRows()">+ Agregar Renglón</button>
        </div>

        <div class="footer-nota">
            <div class="obs-box">
                <div class="d-flex mb-3">
                    <div style="flex:1">
                        <label>Método:</label>
                        <select id="pay-method" class="form-control form-control-sm">
                            <option value="Efectivo">Efectivo</option>
                            <option value="Tarjeta">Tarjeta</option>
                            <option value="Credito">Crédito</option>
                        </select>
                    </div>
                    <div class="ml-3 text-center">
                        <label>¿IVA (16%)?</label>
                        <input type="checkbox" id="chk-iva" onchange="updateTotals()" style="width:22px; height:22px;">
                    </div>
                </div>
                <label>Observaciones:</label>
                <textarea id="val-obs" class="form-control" rows="3" style="border:1px solid #ccc; resize:none;"></textarea>
            </div>
            <div class="totals-box">
                <div class="row-total"><label>SUB-TOTAL $</label><span id="txt-sub">0.00</span></div>
                <div class="row-total"><label>DESCUENTO $</label><input type="number" id="txt-desc" value="0.00" onchange="updateTotals()"></div>
                <div class="row-total"><label>I.V.A. $</label><span id="txt-iva">0.00</span></div>
                <div class="row-total" style="background:#fdecea; height:65px;"><label>TOTAL $</label><span id="txt-total">0.00</span></div>
                <button id="btn-finalizar" class="btn btn-success btn-block py-3 font-weight-bold" style="border-radius:0;" onclick="saveNota()">FINALIZAR VENTA</button>
            </div>
        </div>
    </div>
</div>

<script>
const CFG = { px: '<?= $prefijo ?>', ids: '<?= $idSucursal ?>', idu: '<?= $idUsuario ?>', db: '<?= $dbName ?>', fol: '<?= $folioNota ?>', vend: '<?= $vendedor ?>' };

window.searchProd = async function(input) {
    const q = input.value; const sug = input.nextElementSibling;
    if(q.length < 2) { sug.style.display = 'none'; return; }
    const fd = new FormData(); 
    fd.append('sql', `SELECT p.sku, p.nombre, i.precio_venta, i.costo_promedio FROM \`${CFG.px}Productos_Catalogo\` p INNER JOIN \`${CFG.px}Productos_Inventario\` i ON p.sku = i.sku WHERE p.nombre LIKE '%${q}%' LIMIT 5`);
    fd.append('db', CFG.db);
    const r = await fetch('../librerias/AJAX/Select.php', { method: 'POST', body: fd });
    const res = await r.json();
    sug.innerHTML = res.data.map(p => `<div class="sug-item" onclick="setProd(this, '${p.sku}', '${p.nombre}', ${p.precio_venta}, ${p.costo_promedio})">${p.nombre} ($${p.precio_venta})</div>`).join('');
    sug.style.display = 'block';
};

window.setProd = function(el, sku, nom, price, costo) {
    const row = el.closest('tr');
    row.querySelector('.desc').value = nom; row.querySelector('.sku-hidden').value = sku;
    row.querySelector('.val-price').value = price; row.querySelector('.val-cant').value = 1;
    row.dataset.costo = costo || 0; // Guardar costo para el detalle
    el.parentNode.style.display = 'none'; calcRow(row.querySelector('.val-cant'));
};

function calcRow(input) {
    const row = input.closest('tr');
    const cant = parseFloat(row.querySelector('.val-cant').value) || 0;
    const price = parseFloat(row.querySelector('.val-price').value) || 0;
    row.querySelector('.val-importe').value = (cant * price).toFixed(2);
    updateTotals();
}

function updateTotals() {
    let sub = 0;
    document.querySelectorAll('.val-importe').forEach(i => sub += parseFloat(i.value) || 0);
    const desc = parseFloat(document.getElementById('txt-desc').value) || 0;
    const base = sub - desc;
    const iva = document.getElementById('chk-iva').checked ? (base * 0.16) : 0;
    document.getElementById('txt-sub').innerText = sub.toFixed(2);
    document.getElementById('txt-iva').innerText = iva.toFixed(2);
    document.getElementById('txt-total').innerText = (base + iva).toFixed(2);
}

document.getElementById('cli-nombre').onkeyup = async function() {
    const q = this.value; const resBox = document.getElementById('res-cli-search');
    if(q.length < 3) { resBox.style.display = 'none'; return; }
    const fd = new FormData(); fd.append('sql', `SELECT IDC, Nombre, Telefono FROM \`${CFG.px}Clientes\` WHERE Nombre LIKE '%${q}%' LIMIT 5`);
    fd.append('db', CFG.db);
    const r = await fetch('../librerias/AJAX/Select.php', { method: 'POST', body: fd });
    const res = await r.json();
    resBox.innerHTML = res.data.map(c => `<div class="sug-item" onclick="setCli('${c.IDC}','${c.Nombre}','${c.Telefono}')">${c.Nombre}</div>`).join('');
    resBox.style.display = 'block';
};

window.setCli = function(id, nom, tel) {
    document.getElementById('cli-id').value = id; document.getElementById('cli-nombre').value = nom;
    document.getElementById('cli-tel').value = tel; document.getElementById('res-cli-search').style.display = 'none';
};

async function saveNota() {
    const btnFinalizar = document.getElementById('btn-finalizar');
    const nom = document.getElementById('cli-nombre').value.trim();
    const total = parseFloat(document.getElementById('txt-total').innerText);

    if(!nom || total <= 0) return alert("Faltan datos del cliente o la venta está vacía.");
    if(!confirm("¿Deseas finalizar y generar la nota?")) return;

    btnFinalizar.disabled = true;
    btnFinalizar.innerHTML = `<span class="spinner-border spinner-border-sm"></span> Procesando...`;

    try {
        // 1. Gestionar Cliente
        let idCli = document.getElementById('cli-id').value;
        if(idCli == "0") {
            const rCli = await apiExec(`INSERT INTO \`${CFG.px}Clientes\` (IDU, Nombre, Telefono) VALUES ('CLI-${Date.now()}', '${nom}', '${document.getElementById('cli-tel').value}')`);
            idCli = rCli.last_id;
        }

        // 2. Preparar Items y validar SKUs
        const items = [];
        const rows = document.querySelectorAll('.item-row');
        for (let row of rows) {
            const qty = parseFloat(row.querySelector('.val-cant').value) || 0;
            const nombre = row.querySelector('.desc').value.trim();
            const price = parseFloat(row.querySelector('.val-price').value) || 0;
            const costo = parseFloat(row.dataset.costo) || 0;
            let sku = row.querySelector('.sku-hidden').value;

            if(qty > 0 && nombre !== "") {
                if(!sku) { // Producto manual
                    sku = 'GEN-' + Date.now().toString().slice(-6);
                    const rCat = await apiExec(`INSERT INTO \`${CFG.px}Productos_Catalogo\` (sku, nombre, categoria, tipo_item) VALUES ('${sku}', '${nombre}', 'GENERAL', 'producto')`);
                    await apiExec(`INSERT INTO \`${CFG.px}Productos_Inventario\` (IDP, sku, IDS, existencia, precio_venta, costo_promedio) VALUES (${rCat.last_id}, '${sku}', ${CFG.ids}, 0, ${price}, ${price})`);
                }
                items.push({ sku, nombre, qty, price, costo });
            }
        }

        if(items.length === 0) throw new Error("Debe agregar al menos un producto.");

        // 3. Insertar Cabecera
        const sub = document.getElementById('txt-sub').innerText;
        const dsc = document.getElementById('txt-desc').value;
        const iva = document.getElementById('txt-iva').innerText;
        const met = document.getElementById('pay-method').value;
        const obs = document.getElementById('val-obs').value;

        const sqlCab = `INSERT INTO \`${CFG.px}Ventas_Cabecera\` (Folio, IDC_Cliente, IDU_Usuario, IDS_Sucursal, Metodo_Pago, Subtotal, Descuento, Total, Notas_Venta) VALUES ('${CFG.fol}', ${idCli}, '${CFG.idu}', ${CFG.ids}, '${met}', ${sub}, ${dsc}, ${total}, '${obs}')`;
        const rCab = await apiExec(sqlCab);
        const idVenta = rCab.last_id;

        if(!idVenta) throw new Error("Error al generar cabecera de venta.");

        // 4. Insertar Detalle y Actualizar Inventario
        for(let it of items) {
            const importe = it.qty * it.price;
            // IMPORTANTE: Se incluye Costo_Original para evitar fallo por NOT NULL
            const sqlDet = `INSERT INTO \`${CFG.px}Ventas_Detalle\` (ID_Venta, SKU, Nombre_Producto, Cantidad, Precio_Venta, Costo_Original, Subtotal) VALUES (${idVenta}, '${it.sku}', '${it.nombre}', ${it.qty}, ${it.price}, ${it.costo}, ${importe})`;
            await apiExec(sqlDet);
            
            // Descontar existencia
            await apiExec(`UPDATE \`${CFG.px}Productos_Inventario\` SET existencia = existencia - ${it.qty} WHERE sku = '${it.sku}' AND IDS = ${CFG.ids}`);
        }

        // 5. ENVIAR AL MOTOR DE IMPRESIÓN (Este es el que guarda en Documentos_generados)
        const dataPrint = { 
            folio: CFG.fol, 
            cliente: nom, 
            telefono: document.getElementById('cli-tel').value, 
            items: items, 
            sub: sub, 
            iva: iva, 
            total: total, 
            dsc: dsc, 
            metodo: met, 
            obs: obs,
            idRef: idVenta 
        };

        // Esperamos a que el motor procese (si es async) o mostramos el modal
        if (typeof PrintEngine !== 'undefined') {
            await PrintEngine.show(dataPrint);
            // El modal de impresión suele tener su propio botón de "Cerrar" o "Nueva Venta"
            // Si quieres limpiar la pantalla después de que el modal se cierre:
            // alert("Venta finalizada correctamente.");
            // location.reload(); 
        } else {
            alert("Venta guardada, pero el motor de impresión no está disponible.");
            location.reload();
        }

    } catch (error) {
        console.error("Error en proceso:", error);
        alert("Ocurrió un error: " + error.message);
        btnFinalizar.disabled = false;
        btnFinalizar.innerHTML = "FINALIZAR VENTA";
    }
}

async function apiExec(s) {
    const fd = new FormData(); fd.append('sql', s); fd.append('db', CFG.db);
    const resp = await fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: fd });
    const json = await resp.json();
    if(json.status === "error") throw new Error(json.msg || "Error en ejecución SQL");
    return json;
}

function addMoreRows() {
    const body = document.getElementById('nota-body');
    const newRow = body.rows[0].cloneNode(true);
    newRow.querySelectorAll('input').forEach(i => i.value = (i.className === 'val-importe') ? "0.00" : "");
    newRow.querySelector('.sku-hidden').value = "";
    delete newRow.dataset.costo;
    body.appendChild(newRow);
}
</script>