<?php
// 1. SEGURIDAD Y CONTEXTO
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso Denegado");
}

$DB_NAME = "MS_Datos"; 
$PREFIX = "1"; // Tu prefijo real
$hoy_idx = date('N'); // 1 (Lunes) a 7 (Domingo)
?>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    :root { --primary: #4e73df; --success: #1cc88a; --dark: #1e293b; --bg: #f8fafc; }
    body { background-color: var(--bg); font-family: 'Poppins', sans-serif; }

    /* Estilo del Kiosko de Check-in */
    .kiosko-card { border-radius: 30px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.08); background: #fff; overflow: hidden; }
    .kiosko-header { background: var(--dark); color: white; padding: 40px; text-align: center; }
    
    .search-pill { background: #f1f5f9; border-radius: 50px; padding: 15px 25px; display: flex; align-items: center; border: 2px solid transparent; transition: 0.3s; }
    .search-pill:focus-within { border-color: var(--primary); background: #fff; box-shadow: 0 0 0 5px rgba(78,115,223,0.1); }
    
    /* Perfil del Socio */
    .profile-avatar { width: 100px; height: 100px; border-radius: 50%; background: var(--primary); color: white; display: flex; align-items: center; justify-content: center; font-size: 2.5rem; font-weight: 700; margin: -50px auto 15px; border: 5px solid #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
    
    /* Botones de Clase */
    .btn-clase { 
        background: #fff; border: 2px solid #e2e8f0; border-radius: 20px; 
        padding: 15px; transition: 0.3s; text-align: left; margin-bottom: 12px; width: 100%;
    }
    .btn-clase:hover:not(:disabled) { border-color: var(--primary); transform: translateY(-3px); box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
    .btn-clase b { color: var(--dark); font-size: 1rem; }
    
    /* El WOD (Rutina) */
    .wod-container { background: #f8fafc; border-radius: 20px; padding: 20px; border: 1px dashed #cbd5e1; }
    .wod-item { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #eef2ff; }
</style>

<div class="container py-5">
    
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="kiosko-card">
                <div class="kiosko-header">
                    <h2 class="font-weight-bold mb-1">Check-in <span class="text-primary">Kiosk</span></h2>
                    <p class="opacity-75">Escanea tu token o busca tu nombre para registrar tu asistencia</p>
                    
                    <div class="search-pill mt-4 mx-auto" style="max-width: 500px;">
                        <i class="fas fa-search text-muted mr-3"></i>
                        <input type="text" id="src_asistencia" class="form-control bg-transparent border-0 font-weight-bold" placeholder="NOMBRE O TOKEN..." autocomplete="off">
                    </div>
                    <div id="res_asistencia" class="list-group shadow-lg mt-2 mx-auto" style="max-width: 500px; position: absolute; z-index: 100; left: 0; right: 0;"></div>
                </div>

                <div class="p-5">
                    <div id="perfil_socio" class="d-none animate__animated animate__fadeInUp">
                        <div class="profile-avatar" id="avatar_txt"></div>
                        <div class="text-center mb-4">
                            <h3 id="p_nombre" class="font-weight-bold mb-1"></h3>
                            <div id="p_status"></div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="font-weight-bold text-muted mb-3"><i class="fas fa-calendar-day mr-2"></i>CLASES DISPONIBLES HOY</h6>
                                <div id="clases_hoy"></div>
                            </div>
                            <div class="col-md-6 border-left">
                                <h6 class="font-weight-bold text-muted mb-3"><i class="fas fa-dumbbell mr-2"></i>TU RUTINA DE HOY</h6>
                                <div id="wod_display" class="wod-container text-center">
                                    <p class="small text-muted italic">Selecciona una clase para ver la rutina</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="vacio_img" class="text-center py-5">
                        <i class="fas fa-user-clock fa-4x mb-3 text-light"></i>
                        <h5 class="text-muted">Esperando identificación del socio...</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
window.DB = "<?php echo $DB_NAME; ?>";
window.PREFIX = "<?php echo $PREFIX; ?>";
window.socioActivo = null;

const clean = (res) => { if(!res) return []; let d = res.data || res; return Array.isArray(d) ? d : []; };

// --- 1. BUSCADOR DE SOCIOS ---
document.getElementById('src_asistencia').addEventListener('input', function() {
    let t = this.value; if(t.length < 2) return;
    fetch('../librerias/AJAX/Select.php', { method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'}, body: `sql=${encodeURIComponent(`SELECT IDC, Nombre, Token FROM \`${window.PREFIX}-Clientes\` WHERE Nombre LIKE '%${t}%' OR Token='${t}' LIMIT 5`)}&db=${window.DB}` })
    .then(r => r.json()).then(res => {
        let h = '';
        clean(res).forEach(s => {
            h += `<a href="#" class="list-group-item list-group-item-action font-weight-bold border-0" onclick='window.prepararCheckIn(${JSON.stringify(s)})'>
                    <i class="fas fa-user-circle mr-2 text-primary"></i> ${s.Nombre} <small class="text-muted">(${s.Token})</small>
                  </a>`;
        });
        document.getElementById('res_asistencia').innerHTML = h;
    });
});

// --- 2. PREPARAR INTERFAZ DEL SOCIO ---
window.prepararCheckIn = function(s) {
    window.socioActivo = s;
    $('#p_nombre').text(s.Nombre);
    $('#avatar_txt').text(s.Nombre.charAt(0));
    $('#perfil_socio').removeClass('d-none');
    $('#vacio_img').addClass('d-none');
    $('#res_asistencia').empty();
    $('#src_asistencia').val('');

    // Validar Membresía
    const hoy = new Date().toISOString().split('T')[0];
    fetch('../librerias/AJAX/Select.php', { method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'}, body: `sql=${encodeURIComponent(`SELECT * FROM \`${window.PREFIX}-Gym_Membresias_Asignadas\` WHERE IDC=${s.IDC} AND Fecha_Fin >= '${hoy}' LIMIT 1`)}&db=${window.DB}` })
    .then(r => r.json()).then(res => {
        if(clean(res).length > 0) {
            $('#p_status').html('<span class="badge bg-success text-white px-4 py-2 rounded-pill shadow-sm">MEMBRESÍA ACTIVA</span>');
            window.cargarOpcionesClases(<?php echo $hoy_idx; ?>);
        } else {
            $('#p_status').html('<span class="badge bg-danger text-white px-4 py-2 rounded-pill shadow-sm">VENCIDO / SIN PAGO</span>');
            $('#clases_hoy').html('<div class="alert alert-danger rounded-xl">Acceso bloqueado por falta de pago.</div>');
        }
    });
};

// --- 3. CARGAR CLASES Y SUS RUTINAS (WOD) ---
window.cargarOpcionesClases = function(dia) {
    const sql = `
        SELECT h.IDH, h.Hora_Inicio, h.Ubicacion_Sala, c.Nombre_Clase, c.Ejercicios_JSON 
        FROM \`${window.PREFIX}-Gym_Clases_Horarios\` h 
        JOIN \`${window.PREFIX}-Gym_Clases_Catalogo\` c ON h.IDClase = c.IDClase 
        WHERE h.Dia_Semana = ${dia} ORDER BY h.Hora_Inicio ASC`;

    fetch('../librerias/AJAX/Select.php', { method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'}, body: `sql=${encodeURIComponent(sql)}&db=${window.DB}` })
    .then(r => r.json()).then(res => {
        const div = $('#clases_hoy').empty();
        clean(res).forEach(h => {
            div.append(`
                <button class="btn-clase d-flex align-items-center" onclick='window.verWod(${JSON.stringify(h)})'>
                    <div class="mr-3 text-primary"><i class="fas fa-clock fa-lg"></i></div>
                    <div>
                        <b>${h.Nombre_Clase}</b><br>
                        <small class="text-muted">${h.Hora_Inicio.substring(0,5)} hs | ${h.Ubicacion_Sala || 'Sala Gral'}</small>
                    </div>
                </button>
            `);
        });
    });
};

// --- 4. VISUALIZAR WOD Y REGISTRAR ---
window.verWod = function(clase) {
    const wodDiv = $('#wod_display').empty();
    let ejercicios = [];
    try { ejercicios = JSON.parse(clase.Ejercicios_JSON || '[]'); } catch(e) { ejercicios = []; }

    if(ejercicios.length > 0) {
        ejercicios.forEach(e => {
            wodDiv.append(`
                <div class="wod-item">
                    <span class="font-weight-bold text-dark">${e.Nombre}</span>
                    <span class="badge badge-primary rounded-pill px-3">${e.Reps}</span>
                </div>
            `);
        });
    } else {
        wodDiv.html('<p class="text-muted">No hay rutina asignada a esta clase.</p>');
    }

    // Botón de Check-in Final
    wodDiv.append(`
        <button class="btn btn-success btn-block rounded-pill font-weight-bold py-3 mt-4 shadow-lg animate__animated animate__pulse animate__infinite" onclick="window.confirmarAsistencia(${clase.IDH}, '${clase.Nombre_Clase}')">
            REGISTRAR ENTRADA
        </button>
    `);
};

// --- 5. INSERTAR ASISTENCIA ---
window.confirmarAsistencia = function(idh, nombreClase) {
    const sqlInsert = `INSERT INTO \`${window.PREFIX}-Gym_Asistencias\` (IDC, IDH, Fecha, Hora_Checkin, Metodo_Validacion, Estatus_Asistencia) VALUES (${window.socioActivo.IDC}, ${idh}, CURDATE(), CURTIME(), 'Kiosk', 'Confirmada')`;

    fetch('../librerias/AJAX/Execute.php', { method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'}, body: `sql=${encodeURIComponent(sqlInsert)}&db=${window.DB}` })
    .then(() => {
        Swal.fire({
            title: '¡Check-in Exitoso!',
            html: `Disfruta tu clase de <b>${nombreClase}</b>.<br>Tu rutina ya está disponible.`,
            icon: 'success',
            timer: 3000,
            showConfirmButton: false
        });
        // Resetear Kiosko
        $('#perfil_socio').addClass('d-none');
        $('#vacio_img').removeClass('d-none');
    });
};
</script>