<?php
// =============================================================================
// CAPA 1: LOGICA DE BACKEND Y SEGURIDAD
// =============================================================================
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Validación de Acceso
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso Denegado");
}

// Configuración de Base de Datos y Tabla
$DB_NAME = "MS_Datos"; 
$IDC_EMPRESA = $_SESSION['IDUg'] ?? 1; 
$TABLA = "$IDC_EMPRESA-Choferes"; // Ej: 1-Choferes
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    body { background-color: #f8f9fa; }
    .card-metric { border: none; border-radius: 12px; background: white; box-shadow: 0 4px 10px rgba(0,0,0,0.03); }
    .table-ui thead th { font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; color: #6c757d; background: #fdfdfd; border-bottom: 2px solid #eee; padding: 15px; }
    .status-pill { padding: 5px 12px; border-radius: 20px; font-size: 10px; font-weight: bold; color: white; text-transform: uppercase; }
    .bg-active { background-color: #2ed8b6; box-shadow: 0 2px 5px rgba(46, 216, 182, 0.3); }
    .bg-inactive { background-color: #ff5370; box-shadow: 0 2px 5px rgba(255, 83, 112, 0.3); }
    .btn-icon-sm { width: 32px; height: 32px; display: inline-flex; align-items: center; justify-content: center; border-radius: 8px; }
</style>

<div class="container-fluid p-4">
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div><small class="text-muted font-weight-bold d-block mb-1">TOTAL OPERADORES</small><h3 class="mb-0 font-weight-bold" id="kpi_total">0</h3></div>
                    <div class="icon-shape bg-light-primary text-primary rounded-circle p-3"><i class="fas fa-id-card fa-2x"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div><small class="text-muted font-weight-bold d-block mb-1">ESTADO ACTIVO</small><h3 class="mb-0 text-success font-weight-bold" id="kpi_activos">0</h3></div>
                    <div class="icon-shape bg-light-success text-success rounded-circle p-3"><i class="fas fa-user-check fa-2x"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4">
        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 font-weight-bold"><i class="fas fa-steering-wheel mr-2 text-primary"></i>Gestión de Choferes</h5>
            <button class="btn btn-primary shadow-sm" onclick="abrirModal()">
                <i class="fas fa-plus-circle mr-1"></i> Nuevo Operador
            </button>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle table-ui mb-0">
                <thead>
                    <tr>
                        <th class="text-center">ID</th>
                        <th>Nombre del Operador</th>
                        <th>Licencia / Vencimiento</th>
                        <th>Contacto</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-right pr-4">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tabla_body"></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalChofer" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0">
            <div class="modal-header bg-dark text-white">
                <h5 class="modal-title font-weight-bold">Registro de Chofer</h5>
                <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body p-4">
                <form id="formChofer">
                    <input type="hidden" id="ID_Chofer">
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label class="font-weight-bold">Nombre Completo *</label>
                            <input type="text" class="form-control" id="Nombre" required placeholder="Ej. Juan Pérez García">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Número de Licencia</label>
                            <input type="text" class="form-control" id="Licencia" placeholder="ABC-12345">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Vigencia de Licencia</label>
                            <input type="date" class="form-control" id="Vigencia_Licencia">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Teléfono Movil</label>
                            <input type="text" class="form-control" id="Telefono" placeholder="10 dígitos">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Estatus Operativo</label>
                            <select class="form-control" id="Activo">
                                <option value="1">Activo / Disponible</option>
                                <option value="0">Inactivo / Baja</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-light border-0">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary px-4 font-weight-bold" onclick="guardarChofer()">GUARDAR DATOS</button>
            </div>
        </div>
    </div>
</div>

<script>
const DB = "<?php echo $DB_NAME; ?>";
const TABLA = "<?php echo $TABLA; ?>";
const IDC_EMPRESA = "<?php echo $IDC_EMPRESA; ?>";

document.addEventListener('DOMContentLoaded', () => { window.listarChoferes(); });

// --- LISTAR DATOS ---
window.listarChoferes = function() {
    const sql = `SELECT * FROM \`${TABLA}\` WHERE IDC_Empresa = ${IDC_EMPRESA} ORDER BY ID_Chofer DESC`;
    
    fetch('../librerias/AJAX/Select.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB}`
    })
    .then(r => r.json())
    .then(res => {
        const d = res.data || (Array.isArray(res) ? res : []);
        const tbody = document.getElementById('tabla_body');
        tbody.innerHTML = '';
        
        let tot = 0, act = 0;
        d.forEach(row => {
            tot++; if(row.Activo == 1) act++;
            
            tbody.innerHTML += `
                <tr>
                    <td class="text-center font-weight-bold text-muted">${row.ID_Chofer}</td>
                    <td><div class="font-weight-bold text-dark">${row.Nombre}</div></td>
                    <td>
                        <div class="small"><b>LIC:</b> ${row.Licencia || '<span class="text-danger">N/A</span>'}</div>
                        <div class="small text-muted"><b>VENCE:</b> ${row.Vigencia_Licencia || 'No definida'}</div>
                    </td>
                    <td><i class="fas fa-phone-alt mr-1 text-muted small"></i> ${row.Telefono || 'N/A'}</td>
                    <td class="text-center">
                        <span class="status-pill ${row.Activo == 1 ? 'bg-active' : 'bg-inactive'}">
                            ${row.Activo == 1 ? 'Activo' : 'Inactivo'}
                        </span>
                    </td>
                    <td class="text-right pr-4">
                        <button class="btn btn-light btn-icon-sm border shadow-sm" onclick='editarChofer(${JSON.stringify(row)})'>
                            <i class="fas fa-edit text-primary"></i>
                        </button>
                    </td>
                </tr>`;
        });
        document.getElementById('kpi_total').innerText = tot;
        document.getElementById('kpi_activos').innerText = act;
    });
};

// --- GUARDAR O ACTUALIZAR ---
window.guardarChofer = async function() {
    const id = document.getElementById('ID_Chofer').value;
    const nombre = document.getElementById('Nombre').value.trim();
    
    if(!nombre) return Swal.fire('Atención', 'El nombre del operador es obligatorio', 'warning');

    const safe = (s) => s ? s.replace(/'/g, "\\'") : '';
    
    // Tratamiento de Fecha: Si está vacía, enviamos NULL sin comillas a SQL
    const fVence = document.getElementById('Vigencia_Licencia').value;
    const valVence = fVence ? `'${fVence}'` : 'NULL';

    const d = {
        Nombre: safe(nombre),
        Licencia: safe(document.getElementById('Licencia').value),
        Telefono: safe(document.getElementById('Telefono').value),
        Activo: document.getElementById('Activo').value
    };

    let sql = "";
    if(id) {
        // UPDATE
        sql = `UPDATE \`${TABLA}\` SET 
               Nombre='${d.Nombre}', 
               Licencia='${d.Licencia}', 
               Vigencia_Licencia=${valVence}, 
               Telefono='${d.Telefono}', 
               Activo=${d.Activo} 
               WHERE ID_Chofer=${id} AND IDC_Empresa=${IDC_EMPRESA}`;
    } else {
        // INSERT
        sql = `INSERT INTO \`${TABLA}\` (IDC_Empresa, Nombre, Licencia, Vigencia_Licencia, Telefono, Activo) 
               VALUES (${IDC_EMPRESA}, '${d.Nombre}', '${d.Licencia}', ${valVence}, '${d.Telefono}', ${d.Activo})`;
    }

    fetch('../librerias/AJAX/Execute.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB}`
    })
    .then(r => r.json())
    .then(res => {
        // CORRECCIÓN AQUÍ: Validamos múltiples tipos de éxito
        const exito = (res.status && (res.status.toUpperCase() === 'OK' || res.status.toLowerCase() === 'success'));
        
        if(exito) {
            Swal.fire({ icon: 'success', title: '¡Excelente!', text: 'Los datos se guardaron correctamente', timer: 2000, showConfirmButton: false });
            $('#modalChofer').modal('hide');
            window.listarChoferes();
        } else {
            // Si el status no es OK, revisamos si el mensaje indica error real
            console.error("Respuesta del servidor:", res);
            Swal.fire('Error de Sincronización', res.mensaje || 'Respuesta inesperada del servidor', 'error');
        }
    })
    .catch(err => {
        console.error("Error Fetch:", err);
        Swal.fire('Error Crítico', 'No se pudo conectar con el servidor AJAX', 'error');
    });
};

// --- HELPERS UI ---
window.abrirModal = () => { 
    document.getElementById('formChofer').reset(); 
    document.getElementById('ID_Chofer').value = ''; 
    $('#modalChofer').modal('show'); 
};

window.editarChofer = (row) => {
    document.getElementById('ID_Chofer').value = row.ID_Chofer;
    document.getElementById('Nombre').value = row.Nombre;
    document.getElementById('Licencia').value = row.Licencia;
    document.getElementById('Vigencia_Licencia').value = row.Vigencia_Licencia;
    document.getElementById('Telefono').value = row.Telefono;
    document.getElementById('Activo').value = row.Activo;
    $('#modalChofer').modal('show');
};
</script>