<?php
/**
 * MODULO: Edición de Perfil de Usuario Pro
 * Arquitectura: Modular MS (Carga mediante index.php?A=perfil)
 * Estándar: UI/UX Expert - Sincronización Doble Tabla
 */

// 1. VALIDACIÓN DE SEGURIDAD
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("<div class='alert alert-danger'>Acceso no autorizado.</div>");
}

$db_ms = "MS_Usuario"; 
$IDU_SESSION = $_SESSION['IDU']; 
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    :root { --ms-primary: #448aff; --ms-success: #2ed8b6; --ms-dark: #2c3e50; }
    
    body { background-color: #f8f9fa; }

    /* CAPA B: DISEÑO ESTÁTICO (Evita saltos visuales) */
    .tab-content-fixed {
        min-height: 480px; 
        max-height: 480px;
        overflow-y: auto;
        padding: 30px;
        background: #fff;
        border: 1px solid #edf2f9;
        border-top: none;
        border-radius: 0 0 15px 15px;
    }

    .nav-tabs-ms {
        background: #f8f9fe;
        border: none;
        padding: 10px 10px 0 10px;
        border-radius: 15px 15px 0 0;
    }

    .nav-tabs-ms .nav-link { border: none; color: #8898aa; font-weight: 700; text-transform: uppercase; font-size: 11px; letter-spacing: 1px; padding: 15px 25px; transition: 0.3s; }
    .nav-tabs-ms .nav-link.active {
        background: #fff !important;
        color: var(--ms-primary) !important;
        border-radius: 10px 10px 0 0;
        box-shadow: 0 -5px 15px rgba(0,0,0,0.05);
    }

    /* Avatar Side Card */
    .card-profile-side { border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.05); transition: 0.3s; }
    .img-wrapper { position: relative; width: 150px; height: 150px; margin: 0 auto; }
    .img-wrapper img { width: 100%; height: 100%; object-fit: cover; border-radius: 20%; border: 5px solid #fff; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
    .badge-edit { position: absolute; bottom: -10px; right: -10px; background: var(--ms-primary); color: #fff; width: 42px; height: 42px; border-radius: 12px; display: flex; align-items: center; justify-content: center; cursor: pointer; border: 4px solid #fff; transition: 0.2s; }
    .badge-edit:hover { transform: scale(1.1); }

    /* Formulario */
    .form-group label { font-size: 11px; font-weight: 800; color: #adb5bd; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 8px; }
    .form-control-ms { border-radius: 10px; border: 1px solid #e9ecef; padding: 12px 15px; font-weight: 500; background-color: #fbfcfe; }
    .form-control-ms:focus { border-color: var(--ms-primary); background-color: #fff; box-shadow: 0 0 0 4px rgba(68,138,255,0.1); }
</style>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-xl-4 col-lg-5">
            <div class="card card-profile-side text-center p-5 mb-4 bg-white">
                <div class="img-wrapper">
                    <img src="http://167.172.224.160/MS/librerias/Archivos/usuario.png" id="p_preview" alt="User">
                    <div class="badge-edit" onclick="document.getElementById('file-input').click();">
                        <i class="fas fa-camera"></i>
                    </div>
                    <input type="file" id="file-input" style="display:none" accept="image/*" onchange="algoritmoProcesarImagen(event)">
                </div>
                <h4 class="mt-4 font-weight-bold" id="side-nombre">Cargando...</h4>
                <p class="text-primary font-weight-bold" id="side-rol">...</p>
                
                <input type="hidden" id="b64_full">
                <input type="hidden" id="b64_thumb">

                <div class="px-2 mt-4">
                    <button class="btn btn-primary btn-block shadow-sm py-3" onclick="guardarTodo()" style="border-radius: 12px;">
                        <i class="fas fa-save mr-2"></i>GUARDAR CAMBIOS
                    </button>
                    <button class="btn btn-link text-danger btn-sm mt-3" onclick="eliminarFoto()">
                        <i class="fas fa-trash-alt mr-1"></i> Eliminar foto actual
                    </button>
                </div>
            </div>
        </div>

        <div class="col-xl-8 col-lg-7">
            <div class="card shadow-sm border-0 bg-white" style="border-radius: 15px;">
                <ul class="nav nav-tabs nav-tabs-ms" role="tablist">
                    <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#t-gen"><i class="fas fa-id-card mr-2"></i>General</a></li>
                    <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#t-sec"><i class="fas fa-shield-alt mr-2"></i>Seguridad</a></li>
                    <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#t-fis"><i class="fas fa-file-invoice-dollar mr-2"></i>Fiscal</a></li>
                </ul>

                <form id="main-profile-form">
                    <div class="tab-content tab-content-fixed">
                        <div class="tab-pane fade show active" id="t-gen">
                            <div class="form-group mb-4">
                                <label>Nombre Completo</label>
                                <input type="text" class="form-control form-control-ms" id="i_nombre" placeholder="Nombre completo">
                            </div>
                            <div class="row">
                                <div class="col-md-6 form-group">
                                    <label>Email Corporativo</label>
                                    <input type="email" class="form-control form-control-ms" id="i_email">
                                </div>
                                <div class="col-md-6 form-group">
                                    <label>Teléfono Movil</label>
                                    <input type="text" class="form-control form-control-ms" id="i_tel">
                                </div>
                            </div>
                            <div class="form-group mt-3">
                                <label>Dirección</label>
                                <textarea class="form-control form-control-ms" id="i_dir" rows="3"></textarea>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="t-sec">
                            <div class="form-group mb-4">
                                <label>ID de Acceso (@)</label>
                                <input type="text" class="form-control bg-light" id="i_user_acc" readonly>
                            </div>
                            <div class="form-group">
                                <label class="text-primary">Cambiar Contraseña</label>
                                <input type="password" class="form-control form-control-ms" id="i_pass" placeholder="Nueva clave (solo si desea cambiar)">
                                <small class="text-muted"><i class="fas fa-info-circle mr-1 mt-2"></i> La contraseña actual no se modificará si este campo queda vacío.</small>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="t-fis">
                            <div id="contenedor-fiscal" class="row">
                                </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
const DB_MS = "<?php echo $db_ms; ?>";
const IDU_USER = "<?php echo $IDU_SESSION; ?>";

document.addEventListener("DOMContentLoaded", cargarDatos);

// --- CAPA A: CARGA DE DATOS ---
function cargarDatos() {
    const sql = `SELECT u.*, d.User, d.Rol, d.Datos FROM Usuarios u INNER JOIN Usuarios_Datos d ON u.IDU = d.IDU WHERE u.IDU = ${IDU_USER}`;
    
    fetch('../librerias/AJAX/Select.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB_MS}`
    })
    .then(r => r.json())
    .then(res => {
        const d = res.data ? res.data[0] : (Array.isArray(res) ? res[0] : res);
        if(!d) return;

        document.getElementById('i_nombre').value = d.Nombre || '';
        document.getElementById('side-nombre').innerText = d.Nombre || 'Usuario';
        document.getElementById('i_email').value = d.EMail || '';
        document.getElementById('i_tel').value = d.Telefono_1 || '';
        document.getElementById('i_dir').value = d.Direccion || '';
        document.getElementById('i_user_acc').value = d.User || '';
        document.getElementById('side-rol').innerText = d.Rol || 'Colaborador';
        
        if(d.Foto) document.getElementById('p_preview').src = d.Foto;

        // Cargar JSON Fiscal
        try {
            const fiscal = typeof d.Datos === 'string' ? JSON.parse(d.Datos) : (d.Datos || { RFC: "", Razon_Social: "" });
            let html = "";
            for(let key in fiscal) {
                html += `<div class="col-md-6 form-group">
                            <label>${key.replace('_', ' ')}</label>
                            <input type="text" class="form-control form-control-ms fis-field" data-key="${key}" value="${fiscal[key]}">
                         </div>`;
            }
            document.getElementById('contenedor-fiscal').innerHTML = html;
        } catch(e) { console.error("Error JSON:", e); }
    });
}

// --- ALGORITMO: PROCESAMIENTO E IMAGEN ---

function algoritmoProcesarImagen(event) {
    const file = event.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onload = function(e) {
        const img = new Image();
        img.onload = function() {
            // Comprimir Full (1000px max)
            document.getElementById('b64_full').value = redimensionar(img, 1000, 0.8);
            document.getElementById('p_preview').src = document.getElementById('b64_full').value;
            // Comprimir Thumb (150px)
            document.getElementById('b64_thumb').value = redimensionar(img, 150, 0.7);
        };
        img.src = e.target.result;
    };
    reader.readAsDataURL(file);
}

function redimensionar(img, maxSide, calidad) {
    const canvas = document.createElement('canvas');
    let width = img.width, height = img.height;
    if (width > height) { if (width > maxSide) { height *= maxSide / width; width = maxSide; } }
    else { if (height > maxSide) { width *= maxSide / height; height = maxSide; } }
    canvas.width = width; canvas.height = height;
    const ctx = canvas.getContext('2d');
    ctx.drawImage(img, 0, 0, width, height);
    return canvas.toDataURL('image/jpeg', calidad);
}

// --- CAPA C: GUARDADO Y SINCRONIZACIÓN ---
async function guardarTodo() {
    const pass = document.getElementById('i_pass').value;
    const foto = document.getElementById('b64_full').value;
    const thumb = document.getElementById('b64_thumb').value;
    const fiscal = {};
    document.querySelectorAll('.fis-field').forEach(i => { fiscal[i.getAttribute('data-key')] = i.value; });

    let hash = "";
    if(pass) {
        const r = await fetch('../librerias/AJAX/Pass.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({ passwordCliente: pass })
        }).then(res => res.json());
        hash = r.hash_guardado;
    }

    const safe = (s) => s ? s.replace(/'/g, "''") : '';

    // SQL 1: Tabla Usuarios (Incluye Fotos)
    let sql1 = `UPDATE Usuarios SET Nombre='${safe(document.getElementById('i_nombre').value)}', EMail='${safe(document.getElementById('i_email').value)}', Telefono_1='${safe(document.getElementById('i_tel').value)}', Direccion='${safe(document.getElementById('i_dir').value)}'`;
    if(foto) sql1 += `, Foto='${foto}', Foto_Thumb='${thumb}'`;
    sql1 += ` WHERE IDU=${IDU_USER}`;

    // SQL 2: Tabla Usuarios_Datos (Cifrado y JSON)
    let updP = hash ? `, Password='${hash}'` : '';
    const sql2 = `UPDATE Usuarios_Datos SET Datos='${JSON.stringify(fiscal)}' ${updP} WHERE IDU=${IDU_USER}`;

    console.group("%c💾 MS SYSTEM SYNC", "color: #448aff; font-weight: bold;");
    console.log("SQL Usuarios:", sql1);
    console.log("SQL Datos:", sql2);
    console.groupEnd();

    Swal.fire({ title: 'Sincronizando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

    try {
        await ejecutarSQL(sql1);
        await ejecutarSQL(sql2);
        Swal.fire('¡Éxito!', 'Perfil actualizado correctamente.', 'success');
        cargarDatos();
    } catch(e) { Swal.fire('Error', 'Fallo en la comunicación con el servidor.', 'error'); }
}

function ejecutarSQL(sql) {
    return fetch('../librerias/AJAX/Execute.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB_MS}`
    }).then(r => r.json());
}

function eliminarFoto() {
    Swal.fire({
        title: '¿Eliminar fotografía?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, eliminar'
    }).then((result) => {
        if (result.isConfirmed) {
            const sql = `UPDATE Usuarios SET Foto=NULL, Foto_Thumb=NULL WHERE IDU=${IDU_USER}`;
            ejecutarSQL(sql).then(() => {
                Swal.fire('Eliminado', 'Se restableció el avatar.', 'success');
                document.getElementById('p_preview').src = 'http://167.172.224.160/MS/librerias/Archivos/usuario.png';
            });
        }
    });
}
</script>