<?php
// ==========================================
// 1. SEGURIDAD Y CONTEXTO
// ==========================================
session_start();
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    exit("Acceso denegado. No hay sesión válida.");
}
// Capturamos el ID del módulo actual de la URL para referencias futuras
$modulo_actual = isset($_GET['A']) ? htmlspecialchars($_GET['A']) : '';
?>

<style>
    /* Estilos Generales */
    .gestor-accesos-wrapper { width: 100%; font-family: inherit; }
    
    /* Tarjeta del Menú */
    .mi-tarjeta {
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        transition: all 0.3s ease;
        position: relative;
        cursor: pointer; /* Indica que es clicable */
        min-height: 85px;
    }
    
    /* Estado Activo (Seleccionado) */
    .mi-tarjeta.activo {
        border-color: #007bff !important;
        background-color: #f0f8ff !important;
        box-shadow: 0 4px 8px rgba(0,123,255,0.15);
    }
    .mi-tarjeta.activo::before {
        content: '';
        position: absolute;
        left: 0; top: 0; bottom: 0;
        width: 5px;
        background-color: #007bff;
        border-top-left-radius: 8px;
        border-bottom-left-radius: 8px;
    }

    /* Iconos */
    .mi-icono {
        font-size: 22px;
        color: #6c757d;
        margin-right: 15px;
        width: 40px;
        text-align: center;
        transition: color 0.3s;
    }
    .mi-tarjeta.activo .mi-icono { color: #007bff !important; }

    /* --- SWITCH PURO CSS (Interruptor) --- */
    .switch-puro {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 28px;
        flex-shrink: 0; 
    }
    .switch-puro input { opacity: 0; width: 0; height: 0; }
    
    .slider-round {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider-round:before {
        position: absolute;
        content: "";
        height: 20px;
        width: 20px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    input:checked + .slider-round { background-color: #007bff !important; }
    input:checked + .slider-round:before { transform: translateX(22px); }

    /* Overlay de Carga */
    #loading-overlay {
        display: none;
        position: fixed; top:0; left:0; width:100%; height:100%;
        background:rgba(255,255,255,0.85);
        z-index:9999;
        text-align:center;
        padding-top: 20%;
    }
</style>

<div id="loading-overlay">
    <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
        <span class="sr-only">Cargando...</span>
    </div>
    <h5 class="mt-3 text-muted" id="loading-text">Procesando...</h5>
</div>

<div class="pcoded-inner-content gestor-accesos-wrapper">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">

                <div class="card">
                    <div class="card-header">
                        <h5>Administrar Accesos</h5>
                        <div class="card-header-right" style="min-width: 300px;">
                            <select id="select-usuario" class="form-control" style="height: 40px;">
                                <option value="">-- Cargando lista de usuarios... --</option>
                            </select>
                        </div>
                    </div>

                    <div class="card-block">
                        
                        <div id="alert-box" style="display:none;" class="alert"></div>

                        <div id="estado-vacio" class="text-center py-5">
                            <i class="feather icon-users" style="font-size: 40px; color: #ddd;"></i>
                            <h4 class="text-muted mt-3">Selecciona un usuario para gestionar sus permisos.</h4>
                        </div>

                        <div id="panel-permisos" style="display:none;">
                            
                            <div class="row align-items-center mb-4 p-3" style="background: #f8f9fa; border-radius: 5px;">
                                <div class="col-md-8">
                                    <h6 class="m-0">
                                        Usuario: <span id="nombre-usuario-seleccionado" style="color:#007bff; font-weight:bold; font-size: 1.1em;">...</span>
                                    </h6>
                                    <small class="text-muted">Marca los módulos para dar acceso. Se crearán automáticamente las tablas necesarias.</small>
                                </div>
                                <div class="col-md-4 text-right">
                                    <button type="button" onclick="guardarCambios()" class="btn btn-primary btn-round shadow-sm">
                                        <i class="feather icon-save"></i> Guardar Cambios
                                    </button>
                                </div>
                            </div>
                            
                            <hr>

                            <div id="contenedor-menu"></div>
                            
                            <div class="d-md-none mt-4">
                                <button type="button" onclick="guardarCambios()" class="btn btn-primary btn-block btn-round">
                                    Guardar Cambios
                                </button>
                            </div>

                        </div> </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
    // ---------------------------------------------------
    // A. CONFIGURACIÓN
    // ---------------------------------------------------
    const API_READ  = '../librerias/AJAX/Select.php';
    const API_WRITE = '../librerias/AJAX/Execute.php';
    
    const DB_MAIN   = 'MS_Usuario'; // BD de Permisos y Catálogo
    const DB_DATOS  = 'MS_Datos';   // BD donde se crean las tablas dinámicas

    // Variables Globales
    let catalogoMenu = [];    // Almacena todo el menú (incluyendo el JSON SQL)
    let usuarioActualID = null;

    // ---------------------------------------------------
    // B. FUNCIONES HELPER (AJAX FETCH)
    // ---------------------------------------------------
    async function sqlSelect(sql, db = DB_MAIN) {
        const formData = new FormData();
        formData.append('sql', sql);
        formData.append('db', db);
        try {
            const response = await fetch(API_READ, { method: 'POST', body: formData });
            return await response.json();
        } catch (error) {
            console.error("Error Select:", error);
            return { status: 'error', message: error };
        }
    }

    async function sqlExecute(sql, db = DB_MAIN) {
        console.log(`%c[SQL -> ${db}]:`, 'color: #007bff; font-weight: bold;', sql);
        
        const formData = new FormData();
        formData.append('sql', sql);
        formData.append('db', db);

        try {
            const response = await fetch(API_WRITE, { method: 'POST', body: formData });
            return await response.json();
        } catch (error) {
            console.error("Error Execute:", error);
            return { status: 'error', message: error };
        }
    }

    // ---------------------------------------------------
    // C. INICIALIZACIÓN
    // ---------------------------------------------------
    document.addEventListener('DOMContentLoaded', async () => {
        mostrarLoading(true, "Iniciando sistema...");
        
        // 1. Cargar lista de Usuarios
        const resUser = await sqlSelect("SELECT IDU, User FROM Usuarios_Datos WHERE IDUg=<?php echo $IDUg;?> ORDER BY User ASC");
        const select = document.getElementById('select-usuario');
        select.innerHTML = '<option value="">-- Seleccionar Usuario --</option>';
        
        if(resUser.status === 'success') {
            resUser.data.forEach(u => {
                const opt = document.createElement('option');
                opt.value = u.IDU;
                opt.textContent = u.User;
                select.appendChild(opt);
            });
        } else {
            mostrarAlerta('danger', 'Error al cargar usuarios. Revisa la conexión.');
        }

        // 2. Cargar Catálogo Completo (ORDENADO POR LA COLUMNA ORDEN)
        const resMenu = await sqlSelect("SELECT * FROM Menu_Catalogo ORDER BY Orden ASC");
        if(resMenu.status === 'success') {
            catalogoMenu = resMenu.data; 
            console.log("Catálogo cargado correctamente:", catalogoMenu.length, "módulos.");
        }

        mostrarLoading(false);

        // Evento al cambiar el select
        select.addEventListener('change', (e) => {
            const idu = e.target.value;
            const nombre = e.target.options[e.target.selectedIndex].text;
            cargarPermisosUsuario(idu, nombre);
        });
    });

    // ---------------------------------------------------
    // D. LÓGICA DE VISTA (RENDER)
    // ---------------------------------------------------
    async function cargarPermisosUsuario(idu, nombreUsuario) {
        if (!idu) {
            document.getElementById('panel-permisos').style.display = 'none';
            document.getElementById('estado-vacio').style.display = 'block';
            usuarioActualID = null;
            return;
        }

        usuarioActualID = idu;
        document.getElementById('nombre-usuario-seleccionado').textContent = nombreUsuario;
        mostrarLoading(true, "Cargando permisos...");

        const resPerms = await sqlSelect(`SELECT IDM FROM Aplicaciones WHERE IDU = ${idu}`);
        const permisosActivos = (resPerms.status === 'success') ? resPerms.data.map(p => parseInt(p.IDM)) : [];

        renderizarMenu(permisosActivos);
        
        document.getElementById('estado-vacio').style.display = 'none';
        document.getElementById('panel-permisos').style.display = 'block';
        mostrarLoading(false);
    }

    function renderizarMenu(activos) {
        const contenedor = document.getElementById('contenedor-menu');
        contenedor.innerHTML = ''; 

        // Agrupar por 'NombreGrupo' manteniendo el orden del catálogo
        const grupos = {};
        catalogoMenu.forEach(item => {
            const g = item.NombreGrupo || 'General';
            if(!grupos[g]) grupos[g] = [];
            grupos[g].push(item);
        });

        // Generar HTML por grupos
        for (const [nombreGrupo, items] of Object.entries(grupos)) {
            const titulo = document.createElement('h6');
            titulo.className = "text-uppercase text-muted mt-4 mb-3";
            titulo.style.fontWeight = "700";
            titulo.style.letterSpacing = "1px";
            titulo.innerHTML = `<i class="feather icon-layers mr-2"></i> ${nombreGrupo}`;
            contenedor.appendChild(titulo);

            const row = document.createElement('div');
            row.className = 'row';

            items.forEach(app => {
                const isActive = activos.includes(parseInt(app.IDM));
                const claseActivo = isActive ? 'activo' : '';
                const checked = isActive ? 'checked' : '';
                const icono = app.Icono || 'feather icon-circle';

                const cardHTML = `
                <div class="col-xl-4 col-md-6">
                    <div class="mi-tarjeta ${claseActivo}" onclick="toggleCheck(this)">
                        <div class="mi-icono"><i class="${icono}"></i></div>
                        
                        <div style="flex-grow: 1; padding-right: 10px; overflow: hidden;">
                            <div style="font-weight: 700; color: #333; margin-bottom: 2px;">${app.NombreMenu}</div>
                            <div class="text-muted" style="font-size: 11px;">
                                <span class="badge badge-light border">ID: ${app.IDM}</span>
                            </div>
                        </div>

                        <div class="switch-puro">
                            <input type="checkbox" class="chk-permiso" value="${app.IDM}" ${checked}>
                            <span class="slider-round"></span>
                        </div>
                    </div>
                </div>`;
                
                row.insertAdjacentHTML('beforeend', cardHTML);
            });
            contenedor.appendChild(row);
        }
    }

    function toggleCheck(card) {
        const checkbox = card.querySelector('input[type="checkbox"]');
        if (event.target !== checkbox && event.target !== checkbox.nextElementSibling) {
            checkbox.checked = !checkbox.checked;
        }
        if(checkbox.checked) card.classList.add('activo');
        else card.classList.remove('activo');
    }

    // ---------------------------------------------------
    // E. LÓGICA DE GUARDADO (CORE)
    // ---------------------------------------------------
    function intentarParsearJSON(str) {
        if (!str || str.trim() === "") return [];
        try {
            const obj = JSON.parse(str);
            return normalizarAArray(obj);
        } catch (e1) {
            try {
                let limpio = str.replace(/\r?\n|\r/g, " "); 
                const obj = JSON.parse(limpio);
                return normalizarAArray(obj);
            } catch (e2) {
                console.error("ERROR JSON CRÍTICO", e2);
                return [];
            }
        }
    }

    function normalizarAArray(obj) {
        if (Array.isArray(obj)) return obj;
        if (typeof obj === 'object' && obj !== null) return Object.values(obj);
        return [];
    }

    async function guardarCambios() {
        if(!usuarioActualID) {
            mostrarAlerta('warning', 'Selecciona un usuario primero.');
            return;
        }

        mostrarLoading(true, "Guardando configuración...");
        console.clear();

        try {
            await sqlExecute(`DELETE FROM Aplicaciones WHERE IDU = ${usuarioActualID}`);

            const checkboxes = document.querySelectorAll('.chk-permiso:checked');
            let inserts = 0;
            let tablasProcesadas = 0;

            for (const chk of checkboxes) {
                const idm = parseInt(chk.value);
                await sqlExecute(`INSERT INTO Aplicaciones (IDU, IDM, Estado) VALUES (${usuarioActualID}, '${idm}', 'Activo')`);
                inserts++;

                const itemMenu = catalogoMenu.find(item => parseInt(item.IDM) === idm);

                if (itemMenu && itemMenu.Datos_Mysql && itemMenu.Datos_Mysql.trim() !== "") {
                    console.group(`[IDM ${idm}] Verificando tablas...`);
                    const queries = intentarParsearJSON(itemMenu.Datos_Mysql);

                    for (let query of queries) {
                        if (query && typeof query === 'string' && query.trim().length > 10) {
                            let sqlFinal = query.replace(/#/g, '<?php echo $IDUg;?>');
                            const resp = await sqlExecute(sqlFinal, DB_DATOS);
                            if(resp.status === 'success' || !resp.message) {
                                tablasProcesadas++;
                            }
                        }
                    }
                    console.groupEnd();
                }
            }
            mostrarAlerta('success', `Permisos actualizados (${inserts}) y estructuras verificadas (${tablasProcesadas}).`);
        } catch (error) {
            mostrarAlerta('danger', "Error: " + error);
        } finally {
            mostrarLoading(false);
        }
    }

    function mostrarLoading(show, text="Cargando...") {
        document.getElementById('loading-text').innerText = text;
        const overlay = document.getElementById('loading-overlay');
        overlay.style.display = show ? 'block' : 'none';
    }

    function mostrarAlerta(tipo, mensaje) {
        const box = document.getElementById('alert-box');
        box.className = `alert alert-${tipo} background-${tipo}`;
        box.style.display = 'block';
        box.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.style.display='none';">×</button>
            <strong>${tipo === 'success' ? '¡Éxito!' : 'Atención:'}</strong> ${mensaje}
        `;
        box.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }
</script>