<?php
// APPS/PerfilCompleto.php
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') exit("Acceso Denegado");

require_once '../librerias/Conexion.php';
require_once '../librerias/Forms/FormJSON.php';

// 1. Datos y Configuración
$sql = "SELECT IDCo, Datos_Generales, Datos_Fiscales, Datos_Contacto FROM MS_Usuario.Configuracion";
$conexion = new Conexion("MS_Usuario");
$resultado = $conexion->obtenerDatos($sql);
$data = $resultado['data'] ?? [];

$configs = [
    'general' => [
        'icon' => 'user', 'title' => 'Datos Personales', 'subtitle' => 'Información básica',
        'cfg' => ['db' => "MS_Usuario", 'table' => "MS_Usuario.Configuracion", 'col_pk' => "IDCo", 'col_json' => "Datos_Generales", 'col_title' => "IDCo"]
    ],
    'fiscal' => [
        'icon' => 'briefcase', 'title' => 'Datos Fiscales', 'subtitle' => 'Facturación y RFC',
        'cfg' => ['db' => "MS_Usuario", 'table' => "MS_Usuario.Configuracion", 'col_pk' => "IDCo", 'col_json' => "Datos_Fiscales", 'col_title' => "IDCo"]
    ],
    'contacto' => [
        'icon' => 'map-pin', 'title' => 'Direcciones', 'subtitle' => 'Envíos y sucursales',
        'cfg' => ['db' => "MS_Usuario", 'table' => "MS_Usuario.Configuracion", 'col_pk' => "IDCo", 'col_json' => "Datos_Contacto", 'col_title' => "IDCo"]
    ]
];
?>

<style>
    /* CSS GRID: La magia para usar todo el espacio */
    .app-grid-container {
        display: grid;
        /* Columna 1: 260px fijos para el menú. Columna 2: 1fr (todo el resto) */
        grid-template-columns: 260px 1fr; 
        /* Altura: Pantalla completa menos la cabecera (ajusta 110px a tu gusto) */
        height: calc(100vh - 110px); 
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        overflow: hidden; /* Evita scroll en el contenedor principal */
    }

    /* MENÚ LATERAL */
    .app-sidebar {
        background-color: #f4f7fa; /* Gris muy suave */
        border-right: 1px solid #e2e5e8;
        overflow-y: auto; /* Scroll si el menú es muy largo */
        padding: 20px 0;
    }

    .app-nav-link {
        display: block;
        padding: 15px 20px;
        color: #6c757d;
        text-decoration: none;
        transition: all 0.2s;
        border-left: 4px solid transparent;
    }
    .app-nav-link:hover {
        background-color: #e9ecef;
        color: #333;
        text-decoration: none;
    }
    .app-nav-link.active {
        background-color: #fff;
        color: #04a9f5; /* Tu color primario */
        border-left-color: #04a9f5;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        font-weight: 600;
    }

    /* CONTENIDO PRINCIPAL */
    .app-content {
        background-color: #fff;
        overflow-y: auto; /* Scroll independiente para el formulario */
        padding: 40px;
        position: relative;
    }

    /* RESPONSIVE: En móviles se vuelve una sola columna */
    @media (max-width: 768px) {
        .app-grid-container {
            grid-template-columns: 1fr;
            grid-template-rows: auto 1fr;
            height: auto;
            min-height: 100vh;
        }
        .app-sidebar { border-right: none; border-bottom: 1px solid #ddd; }
    }
</style>

<div class="col-12 p-0"> <div class="app-grid-container">
        
        <div class="app-sidebar">
            <h6 class="px-4 mb-3 text-muted text-uppercase small font-weight-bold">Configuración</h6>
            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist">
                <?php 
                $isActive = true;
                foreach($configs as $key => $info): 
                    $activeClass = $isActive ? 'active' : '';
                ?>
                    <a class="app-nav-link <?php echo $activeClass; ?>" id="tab-<?php echo $key; ?>" data-toggle="pill" href="#content-<?php echo $key; ?>" role="tab">
                        <div class="d-flex align-items-center">
                            <i class="feather icon-<?php echo $info['icon']; ?> f-20 mr-3"></i>
                            <div>
                                <div class="f-14"><?php echo $info['title']; ?></div>
                                <div style="font-size: 11px; opacity: 0.7"><?php echo $info['subtitle']; ?></div>
                            </div>
                        </div>
                    </a>
                <?php 
                    $isActive = false; 
                endforeach; 
                ?>
            </div>
        </div>

        <div class="app-content">
            <div class="tab-content" id="v-pills-tabContent">
                <?php 
                $isActive = true;
                foreach($configs as $key => $info): 
                    $activeClass = $isActive ? 'show active' : '';
                ?>
                    <div class="tab-pane fade <?php echo $activeClass; ?>" id="content-<?php echo $key; ?>" role="tabpanel">
                        <div class="d-flex justify-content-between align-items-end mb-4 border-bottom pb-2">
                            <div>
                                <h3 class="mb-1 text-dark font-weight-normal"><?php echo $info['title']; ?></h3>
                                <p class="text-muted mb-0"><?php echo $info['subtitle']; ?></p>
                            </div>
                        </div>

                        <?php FormBuilderRender::render($info['cfg'], $data, ucfirst($key)); ?>
                    </div>
                <?php 
                    $isActive = false; 
                endforeach; 
                ?>
            </div>
        </div>

    </div>
</div>