<?php
/**
 * Módulo: Centro de Liquidación v2.1 - Reset de Comensales & Ventas Reales
 */
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso denegado.");
}

$prefijo = $_SESSION['IDUg'] ?? '1'; 
$IDU_SOLO = $_SESSION['IDU'] ?? '0';

// Configuración de Tablas
$tb_clientes  = $prefijo . "-Clientes"; 
$tb_control   = $prefijo . "-Rest_Mesas_Control";
$tb_temp      = $prefijo . "-Rest_Comandas_Temp"; 
$tb_ventas_c  = $prefijo . "-Ventas_Cabecera";
$tb_ventas_d  = $prefijo . "-Ventas_Detalle";
$tb_docs      = $prefijo . "-Documentos_Generados";
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<style>
    :root { 
        --ui-primary: #3867d6; --ui-success: #20bf6b; 
        --ui-danger: #eb3b5a; --ui-dark: #2d3436; --ui-bg: #f5f6fa;
    }

    html, body { height: 100%; margin: 0; background-color: var(--ui-bg); font-family: 'Segoe UI', sans-serif; overflow: hidden; font-size: 18px; }
    .cashier-wrapper { display: flex; flex-direction: column; height: 100vh; width: 100vw; }

    /* Header Ejecutivo */
    .cashier-header { 
        background: var(--ui-dark); color: #fff; padding: 12px 25px; 
        display: flex; justify-content: space-between; align-items: center; 
        border-bottom: 4px solid var(--ui-primary); flex-shrink: 0; 
    }
    .pulse-dot { width: 12px; height: 12px; background: var(--ui-success); border-radius: 50%; display: inline-block; margin-right: 10px; transition: 0.3s; }
    .pulse-syncing { transform: scale(1.5); filter: brightness(1.5); box-shadow: 0 0 12px var(--ui-success); }

    /* Barra de Herramientas con Switch Deslizable */
    .toolbar { background: #fff; padding: 10px 25px; border-bottom: 1px solid #ddd; display: flex; align-items: center; justify-content: space-between; }
    
    .switch-wrap { display: flex; align-items: center; gap: 12px; cursor: pointer; user-select: none; }
    .switch { position: relative; display: inline-block; width: 46px; height: 24px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #cbd5e0; transition: .4s; border-radius: 34px; }
    .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
    input:checked + .slider { background-color: var(--ui-primary); }
    input:checked + .slider:before { transform: translateX(22px); }

    /* Grid de Mesas */
    .table-matrix { 
        flex: 1; display: grid; 
        grid-template-columns: repeat(auto-fill, minmax(320px, 1fr)); 
        grid-auto-rows: min-content; gap: 15px; padding: 15px; overflow-y: auto; 
    }

    .card-mesa { 
        background: #fff; border-radius: 15px; overflow: hidden; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.05); display: flex; flex-direction: column; transition: 0.3s;
        border: 1px solid #eee;
    }
    .card-mesa.hidden { display: none; }
    .card-mesa.ocupada { border-top: 8px solid var(--ui-danger); }
    .card-mesa.libre { border-top: 8px solid var(--ui-success); opacity: 0.6; }

    .card-header-info { padding: 8px 15px; background: #fafafa; display: flex; justify-content: space-between; align-items: center; font-size: 0.85rem; font-weight: bold; color: #636e72; }
    .card-body { padding: 20px; text-align: center; }
    .mesa-name { font-size: 1.4rem; font-weight: 800; color: var(--ui-primary); margin: 0; }
    .total-big { font-size: 2.8rem; font-weight: 900; color: var(--ui-dark); margin: 5px 0; letter-spacing: -1px; }

    .card-actions { display: grid; grid-template-columns: 1fr 1fr; gap: 8px; padding: 12px; background: #f8f9fa; border-top: 1px solid #eee; }
    .btn-pro { border: none; padding: 12px; border-radius: 8px; font-weight: 800; cursor: pointer; transition: 0.2s; }
    .btn-audit { background: #e2e8f0; color: #475569; }
    .btn-pay-pro { background: var(--ui-dark); color: #fff; }

    /* Paneles Laterales */
    .side-panel { position: fixed; top: 0; width: 450px; height: 100vh; background: #fff; box-shadow: -10px 0 40px rgba(0,0,0,0.2); transition: 0.4s; z-index: 1100; display: flex; flex-direction: column; }
    #details-panel { left: -500px; }
    #details-panel.active { left: 0; box-shadow: 10px 0 40px rgba(0,0,0,0.2); }
    #payment-panel { right: -500px; }
    #payment-panel.active { right: 0; }
    .panel-header { padding: 20px; background: var(--ui-dark); color: #fff; display: flex; justify-content: space-between; align-items: center; }
    
    .overlay { position: fixed; top: 0; left: 0; width: 100vw; height: 100vh; background: rgba(0,0,0,0.5); display: none; z-index: 1050; backdrop-filter: blur(4px); }
    .overlay.active { display: block; }

    .method-btn { border: 2px solid #eee; border-radius: 12px; padding: 15px; text-align: center; cursor: pointer; flex: 1; font-weight: 800; }
    .method-btn.active { border-color: var(--ui-primary); background: #f0faff; color: var(--ui-primary); }
</style>

<div class="cashier-wrapper">
    <div class="cashier-header">
        <div>
            <h2 class="m-0"><span class="pulse-dot" id="monitor-dot"></span>CAJA MASTER</h2>
            <small><i class="fas fa-id-badge"></i> Terminal: <b><?php echo $IDU_SOLO; ?></b></small>
        </div>
        <div class="text-right">
            <h3 class="m-0 text-success" id="acumulado-dia">$ 0.00</h3>
            <small class="text-uppercase" style="letter-spacing: 1px;">Ventas del Turno</small>
        </div>
    </div>

    <div class="toolbar">
        <label class="switch-wrap">
            <span class="font-weight-bold">Ocultar mesas libres</span>
            <div class="switch">
                <input type="checkbox" id="toggle-libres" onchange="renderMatrix()">
                <span class="slider"></span>
            </div>
        </label>
        <span class="badge badge-light p-2 border"><i class="fas fa-sync-alt fa-spin mr-1"></i> Monitor en tiempo real</span>
    </div>

    <div class="table-matrix" id="matrix-container"></div>
</div>

<div class="overlay" id="main-overlay" onclick="closeAllPanels()"></div>

<div id="details-panel" class="side-panel">
    <div class="panel-header" style="background:var(--ui-primary)">
        <h4 class="m-0"><i class="fas fa-file-invoice"></i> Resumen</h4>
        <i class="fas fa-times pointer" onclick="closeAllPanels()"></i>
    </div>
    <div class="scroll-content p-4" id="details-content" style="font-family: 'Courier New', monospace; flex:1; overflow-y:auto;"></div>
    <div class="p-3 bg-light border-top">
        <button class="btn btn-primary btn-block py-3 font-weight-bold" onclick="openPaymentFromDetails()">PASAR AL COBRO</button>
    </div>
</div>

<div id="payment-panel" class="side-panel">
    <div class="panel-header">
        <h4 class="m-0"><i class="fas fa-cash-register"></i> Liquidar</h4>
        <i class="fas fa-times pointer" onclick="closeAllPanels()"></i>
    </div>
    <div class="p-4 overflow-auto">
        <div class="text-center mb-4"><h5 id="pay-mesa-label" class="text-muted">--</h5><h1 class="display-3 font-weight-bold" id="pay-total-label">$ 0.00</h1></div>
        <div class="d-flex gap-2 mb-4">
            <div class="method-btn active" id="btn-efectivo" onclick="setPayMethod('Efectivo')"><i class="fas fa-money-bill-wave d-block mb-1"></i> EFECTIVO</div>
            <div class="method-btn" id="btn-tarjeta" onclick="setPayMethod('Tarjeta')"><i class="fas fa-credit-card d-block mb-1"></i> TARJETA</div>
        </div>
        <input type="number" id="pay-received" class="form-control form-control-lg text-center font-weight-bold" style="font-size: 2.5rem; height: 80px; border:2px solid var(--ui-primary)" onkeyup="calcChange()" placeholder="0.00">
        <div class="alert alert-success text-center mt-3">
            <small class="font-weight-bold">CAMBIO:</small>
            <h1 class="m-0 font-weight-bold" id="pay-change-label">$ 0.00</h1>
        </div>
    </div>
    <button class="btn btn-success btn-block py-4 font-weight-bold" onclick="executeTransaction()">FINALIZAR Y LIBERAR MESA</button>
</div>

<script>
    const DB = "MS_Datos";
    const IDU_CAJERO = "<?php echo $IDU_SOLO; ?>";
    const TABS = {
        control: "<?php echo $tb_control; ?>",
        temp: "<?php echo $tb_temp; ?>",
        ventas_c: "<?php echo $tb_ventas_c; ?>",
        ventas_d: "<?php echo $tb_ventas_d; ?>",
        clientes: "<?php echo $tb_clientes; ?>",
        docs: "<?php echo $tb_docs; ?>"
    };

    let curMesa = null, curTotal = 0, curMethod = 'Efectivo', curNombre = '', timers = [];
    let stateHash = ""; 

    document.addEventListener('DOMContentLoaded', () => {
        loadData();
        startMonitor();
    });

    async function apiRequest(endpoint, sql) {
        const formData = new FormData();
        formData.append('sql', sql);
        formData.append('db', DB);
        const res = await fetch(`../librerias/AJAX/${endpoint}`, { method: 'POST', body: formData });
        const json = await res.json();
        return json.data ? json.data : json;
    }

    // Monitor de Sincronización
    function startMonitor() {
        setInterval(async () => {
            const sql = `SELECT CONCAT(COUNT(*), '-', (SELECT COUNT(*) FROM \`${TABS.ventas_c}\` WHERE DATE(Fecha) = CURRENT_DATE)) as h FROM \`${TABS.temp}\``;
            const res = await apiRequest('Select.php', sql);
            if(res && res[0].h !== stateHash) {
                stateHash = res[0].h;
                const dot = document.getElementById('monitor-dot');
                dot.classList.add('pulse-syncing');
                loadData();
                setTimeout(() => dot.classList.remove('pulse-syncing'), 800);
            }
        }, 5000);
    }

    async function loadData() {
        // 1. Acumulado Real
        const resV = await apiRequest('Select.php', `SELECT SUM(Total) as total FROM \`${TABS.ventas_c}\` WHERE DATE(Fecha) = CURRENT_DATE`);
        document.getElementById('acumulado-dia').innerText = `$ ${parseFloat(resV[0].total || 0).toFixed(2)}`;

        // 2. Estado de Mesas
        const sqlMesas = `
            SELECT m.IDC_Mesa, c.Nombre, m.Estado_Mesa, m.Num_Comensales, 
            IFNULL((SELECT SUM(Precio_Venta) FROM \`${TABS.temp}\` WHERE IDC_Mesa = m.IDC_Mesa), 0) as TotalMesa,
            (SELECT MIN(Fecha_Hora) FROM \`${TABS.temp}\` WHERE IDC_Mesa = m.IDC_Mesa) as Inicio
            FROM \`${TABS.control}\` m JOIN \`${TABS.clientes}\` c ON m.IDC_Mesa = c.IDC 
            ORDER BY TotalMesa DESC, c.Nombre ASC`;
        
        window.rawMesas = await apiRequest('Select.php', sqlMesas);
        renderMatrix();
    }

    function renderMatrix() {
        const container = document.getElementById('matrix-container');
        const hideLibres = document.getElementById('toggle-libres').checked;
        container.innerHTML = '';
        timers = [];

        if(Array.isArray(window.rawMesas)) {
            window.rawMesas.forEach(m => {
                const isOcupada = m.Estado_Mesa === 'Ocupada';
                if(hideLibres && !isOcupada) return;

                container.innerHTML += `
                <div class="card-mesa ${isOcupada ? 'ocupada' : 'libre'} shadow-sm">
                    <div class="card-header-info">
                        <span id="timer-${m.IDC_Mesa}">${isOcupada ? '00:00:00' : '--'}</span>
                        <span><i class="fas fa-circle ${isOcupada ? 'text-danger' : 'text-success'}"></i></span>
                    </div>
                    <div class="card-body">
                        <p class="mesa-name">${m.Nombre}</p>
                        <h2 class="total-big">$ ${parseFloat(m.TotalMesa).toFixed(2)}</h2>
                        <small class="text-muted"><i class="fas fa-users"></i> ${m.Num_Comensales} comensales</small>
                    </div>
                    <div class="card-actions">
                        ${isOcupada ? `
                        <button class="btn-pro btn-audit" onclick="showDetails(${m.IDC_Mesa},'${m.Nombre}',${m.TotalMesa})">DETALLES</button>
                        <button class="btn-pro btn-pay-pro" onclick="showPayment(${m.IDC_Mesa},'${m.Nombre}',${m.TotalMesa})">COBRAR</button>` 
                        : `<div class="text-center w-100 py-1 font-weight-bold text-success" style="grid-column: span 2">DISPONIBLE</div>`}
                    </div>
                </div>`;
                if(isOcupada && m.Inicio) timers.push({ id: m.IDC_Mesa, start: new Date(m.Inicio).getTime() });
            });
            updateLiveTimers();
        }
    }

    function updateLiveTimers() {
        if(window.mainInt) clearInterval(window.mainInt);
        window.mainInt = setInterval(() => {
            const now = new Date().getTime();
            timers.forEach(t => {
                const diff = now - t.start;
                const h = Math.floor(diff / 3600000), m = Math.floor((diff % 3600000) / 60000), s = Math.floor((diff % 60000) / 1000);
                const el = document.getElementById(`timer-${t.id}`);
                if(el) el.innerText = `${String(h).padStart(2,'0')}:${String(m).padStart(2,'0')}:${String(s).padStart(2,'0')}`;
            });
        }, 1000);
    }

    async function showDetails(id, nombre, total) {
        curMesa = id; curNombre = nombre; curTotal = total;
        const items = await apiRequest('Select.php', `SELECT * FROM \`${TABS.temp}\` WHERE IDC_Mesa = ${id} ORDER BY Num_Comensal ASC`);
        const content = document.getElementById('details-content');
        content.innerHTML = `<div class="text-center"><b>*** ${nombre} ***</b></div><hr>`;
        if(Array.isArray(items)) {
            items.forEach(it => { content.innerHTML += `<div class="d-flex justify-content-between"><span>${it.Nombre_Producto}</span><b>$${parseFloat(it.Precio_Venta).toFixed(2)}</b></div>`; });
        }
        content.innerHTML += `<hr><div class="d-flex justify-content-between h4"><b>TOTAL</b><b>$${total.toFixed(2)}</b></div>`;
        document.getElementById('details-panel').classList.add('active');
        document.getElementById('main-overlay').classList.add('active');
    }

    function showPayment(id, nombre, total) {
        curMesa = id; curNombre = nombre; curTotal = total;
        document.getElementById('pay-mesa-label').innerText = nombre;
        document.getElementById('pay-total-label').innerText = `$ ${parseFloat(total).toFixed(2)}`;
        document.getElementById('payment-panel').classList.add('active');
        document.getElementById('main-overlay').classList.add('active');
        document.getElementById('pay-received').value = ''; calcChange();
        setTimeout(() => document.getElementById('pay-received').focus(), 500);
    }

    function setPayMethod(m) {
        curMethod = m;
        document.getElementById('btn-efectivo').classList.toggle('active', m === 'Efectivo');
        document.getElementById('btn-tarjeta').classList.toggle('active', m === 'Tarjeta');
    }

    function calcChange() {
        const rec = parseFloat(document.getElementById('pay-received').value) || 0;
        document.getElementById('pay-change-label').innerText = `$ ${Math.max(0, rec - curTotal).toFixed(2)}`;
    }

    function closeAllPanels() {
        document.querySelectorAll('.side-panel').forEach(p => p.classList.remove('active'));
        document.getElementById('main-overlay').classList.remove('active');
    }

    function openPaymentFromDetails() {
        closeAllPanels();
        showPayment(curMesa, curNombre, curTotal);
    }

    async function generarFolio() {
        const d = new Date();
        const fecha = d.getFullYear() + String(d.getMonth() + 1).padStart(2, '0') + String(d.getDate()).padStart(2, '0');
        const res = await apiRequest('Select.php', `SELECT COUNT(*) as hoy FROM \`${TABS.ventas_c}\` WHERE DATE(Fecha) = CURRENT_DATE`);
        const num = (parseInt(res[0].hoy || 0) + 1).toString().padStart(3, '0');
        return `RT-${fecha}-${num}`;
    }

    async function executeTransaction() {
        const rec = parseFloat(document.getElementById('pay-received').value) || 0;
        if(curMethod === 'Efectivo' && rec < curTotal) return Swal.fire('Error', 'Importe insuficiente.', 'error');

        Swal.fire({ title: 'Liquidando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

        try {
            const folio = await generarFolio();
            
            // 1. Cabecera
            await apiRequest('Execute.php', `INSERT INTO \`${TABS.ventas_c}\` (Folio, IDC_Cliente, IDU_Usuario, IDS_Sucursal, Metodo_Pago, Subtotal, Total, Estado) VALUES ('${folio}', ${curMesa}, '${IDU_CAJERO}', 1, '${curMethod}', ${curTotal}, ${curTotal}, 'Pagado')`);
            const resV = await apiRequest('Select.php', `SELECT ID_Venta FROM \`${TABS.ventas_c}\` WHERE Folio = '${folio}' LIMIT 1`);
            const idVenta = resV[0].ID_Venta;

            // 2. Detalle
            const items = await apiRequest('Select.php', `SELECT * FROM \`${TABS.temp}\` WHERE IDC_Mesa = ${curMesa}`);
            let listaTicket = [];
            for(let it of items) {
                await apiRequest('Execute.php', `INSERT INTO \`${TABS.ventas_d}\` (ID_Venta, SKU, Nombre_Producto, Cantidad, Precio_Venta, Costo_Original, Subtotal) VALUES (${idVenta}, '${it.SKU}', '${it.Nombre_Producto}', 1, ${it.Precio_Venta}, 0, ${it.Precio_Venta})`);
                listaTicket.push({ sku: it.SKU, nombre: it.Nombre_Producto, precio: it.Precio_Venta });
            }

            // 3. Impresión (Folio en UUID_Unico)
            const contenidoJSON = JSON.stringify({ folio, mesa: curNombre, items: listaTicket, total: curTotal, cajero: IDU_CAJERO, fecha: new Date().toLocaleString() });
            await apiRequest('Execute.php', `INSERT INTO \`${TABS.docs}\` (UUID_Unico, Modulo_Origen, ID_Referencia, ID_Config_Impresora, Contenido_JSON, Estado) VALUES ('${folio}', 'LiquidacionMesa', ${idVenta}, 1, '${contenidoJSON}', 'PENDIENTE')`);

            // 4. LIMPIEZA TOTAL (INCLUYENDO COMENSALES = 1)
            await apiRequest('Execute.php', `DELETE FROM \`${TABS.temp}\` WHERE IDC_Mesa = ${curMesa}`);
            await apiRequest('Execute.php', `UPDATE \`${TABS.control}\` SET Estado_Mesa = 'Libre', ID_Venta_Activa = NULL, Num_Comensales = 1, Nota_General = '' WHERE IDC_Mesa = ${curMesa}`);

            Swal.fire('Venta Cerrada', `Folio: ${folio}. Mesa Liberada.`, 'success');
            stateHash = ""; 
            closeAllPanels(); loadData();
        } catch (err) {
            Swal.fire('Error', 'Falla en transacción: ' + err.message, 'error');
        }
    }
</script>